/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.sequence;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ksql.util.StringUtil;

public abstract class Sequence {
    static final int SYSTEM_MAX_VALUE = 100000;
    private Lock lock = new ReentrantLock();
    protected String sqlSequenceObjectQuery;
    protected String createSql;
    protected String sqlSequenceQuery;
    protected String sqlTableQuery;
    protected String sqlPkQuery;
    protected DBRoute dbRoute;
    private static final String FORMAT = "Error:%s";

    public Sequence(DBRoute dbRoute) {
        this.dbRoute = dbRoute;
    }

    public boolean hasTableExists(String tableName) {
        return (Boolean)DB.query((DBRoute)this.dbRoute, (String)this.sqlTableQuery, (Object[])new Object[]{new SqlParameter(":A", 12, (Object)tableName.toUpperCase())}, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    Object count = rs.getObject(1);
                    return count != null && ((Number)count).intValue() > 0;
                }
                return Boolean.FALSE;
            }
        });
    }

    public long getTableMaxSeq(String tableName) {
        if (StringUtil.isEmpty((String)tableName)) {
            return 100000L;
        }
        if (this.hasTableExists(tableName)) {
            Object pkField = DB.query((DBRoute)this.dbRoute, (String)this.sqlPkQuery, (Object[])new Object[]{tableName.toUpperCase()}, (ResultSetHandler)new ResultSetHandler<Object>(){

                public Object handle(ResultSet rs) throws Exception {
                    if (rs.next()) {
                        return rs.getObject(1);
                    }
                    return Boolean.FALSE;
                }
            });
            if (pkField == null) {
                return 100000L;
            }
            String sql = String.format("/*dialect*/ select max(t.%s) from %s t", pkField, tableName);
            Object maxValue = DB.query((DBRoute)this.dbRoute, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Object>(){

                public Object handle(ResultSet rs) throws Exception {
                    if (rs.next()) {
                        return rs.getObject(1);
                    }
                    return Boolean.FALSE;
                }
            });
            if (maxValue == null || maxValue instanceof String) {
                return 100000L;
            }
            long maxValueLong = 100000L;
            maxValueLong = Long.parseLong(maxValue.toString());
            return Math.max(maxValueLong, 100000L);
        }
        return 100000L;
    }

    public String getSequenceNameByKey(String tableName) {
        if (tableName.startsWith("t_")) {
            return "Z_" + tableName.substring(2);
        }
        return "Z_" + tableName;
    }

    abstract void repairMaxValue(String var1, String var2, long var3) throws SQLException;

    public boolean hasSequence(String seqName) {
        return (Boolean)DB.query((DBRoute)this.dbRoute, (String)this.sqlSequenceObjectQuery, (Object[])new Object[]{new SqlParameter(":A", 12, (Object)seqName.toUpperCase())}, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    Object count = rs.getObject(1);
                    return count != null && ((Number)count).intValue() > 0;
                }
                return Boolean.FALSE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoCreateSequence(String seqName, String tableName) {
        if (StringUtil.isEmpty((String)tableName)) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{"tableName is empty"});
        }
        if (seqName.length() > 30) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{BosRes.get((String)"bos-ormengine", (String)"Sequence_0", (String)"\u54e6\uff0c\u771f\u7cdf\u7cd5\uff0c\u4e3a\u8868{0}\u5efa\u7acb\u7684\u5e8f\u5217{1}\u65f6\u53d1\u73b0\u8868\u540d\u79f0\u592a\u957f\u4e86\uff08\u8d85\u8fc7\u4e8630\u4e2a\u5b57\u7b26\uff09\uff0c\u5c1d\u8bd5\u5728BOS\u8bbe\u8ba1\u5668\u4e2d\u4fee\u8ba2\u8868\u540d\u79f0\u3002", (Object[])new Object[]{tableName, seqName})});
        }
        this.lock.lock();
        try {
            if (this.hasSequence(seqName)) {
                return;
            }
            long currentValue = this.getTableMaxSeq(tableName) + 1L;
            String createSql = String.format(this.createSql, seqName, currentValue);
            try {
                DB.execute((DBRoute)this.dbRoute, (String)createSql, null);
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s. seqName:%s", e.getMessage(), seqName)});
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T[] getSequence(T[] a, String key, int count) {
        String seqName = this.getSequenceNameByKey(key);
        String sqlSequenceQuery = String.format(this.sqlSequenceQuery, seqName);
        try (TXHandle h = TX.requiresNew((String)"getSequence");){
            Object[] params = new SqlParameter[]{new SqlParameter(":count", 4, (Object)count)};
            if (a.getClass().getComponentType() == Integer.class) {
                int seq = (Integer)DB.query((DBRoute)this.dbRoute, (String)sqlSequenceQuery, (Object[])params, (ResultSetHandler)new ResultSetHandler<Integer>(){

                    public Integer handle(ResultSet rs) throws Exception {
                        if (rs.next()) {
                            return rs.getInt(1);
                        }
                        return 0;
                    }
                });
                Integer[] seqList = new Integer[count];
                int i2 = 0;
                while (true) {
                    if (i2 >= count) {
                        Object[] i2 = seqList;
                        return i2;
                    }
                    seqList[i2] = seq + i2;
                    ++i2;
                }
            }
            long seq = (Long)DB.query((DBRoute)this.dbRoute, (String)sqlSequenceQuery, (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

                public Long handle(ResultSet rs) throws Exception {
                    if (rs.next()) {
                        return rs.getLong(1);
                    }
                    return 0L;
                }
            });
            Long[] seqList = new Long[count];
            for (int i = 0; i < count; ++i) {
                seqList[i] = seq + (long)i;
            }
            Object[] objectArray = seqList;
            return objectArray;
        }
        catch (Exception e2) {
            try (TXHandle h2 = TX.requiresNew((String)"getSequence2");){
                this.autoCreateSequence(seqName, key);
            }
            try {
                return this.getSequence(a, key, count);
            }
            catch (Exception e22) {
                throw new KDException((Throwable)e22, BosErrorCode.sQL, new Object[]{String.format(FORMAT, e2.getMessage())});
            }
        }
    }

    public <T> void repairSequence(T[] a, String key, String seqName, String tableName, boolean isInt32) {
        long seqValue = isInt32 ? (long)((BigDecimal)this.getSequence(a, key, 1)[0]).intValue() : ((BigDecimal)this.getSequence(a, key, 1)[0]).longValue();
        ++seqValue;
        try {
            this.repairMaxValue(seqName, tableName, seqValue);
        }
        catch (SQLException e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(FORMAT, e.getMessage())});
        }
    }

    public boolean repairMaxSeq() {
        return true;
    }
}

