/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core;

import java.util.LinkedList;
import kd.bos.armor.core.Entry;
import kd.bos.armor.core.ErrorEntryFreeException;
import kd.bos.armor.core.context.Context;
import kd.bos.armor.core.context.ContextUtil;
import kd.bos.armor.core.context.NullContext;
import kd.bos.armor.core.log.RecordLog;
import kd.bos.armor.core.node.Node;
import kd.bos.armor.core.slotchain.ProcessorSlot;
import kd.bos.armor.core.slotchain.ResourceWrapper;
import kd.bos.armor.core.util.function.BiConsumer;

class CtEntry
extends Entry {
    protected Entry parent = null;
    protected Entry child = null;
    protected ProcessorSlot<Object> chain;
    protected Context context;
    protected LinkedList<BiConsumer<Context, Entry>> exitHandlers;

    CtEntry(ResourceWrapper resourceWrapper, ProcessorSlot<Object> chain, Context context) {
        super(resourceWrapper);
        this.chain = chain;
        this.context = context;
        this.setUpEntryFor(context);
    }

    private void setUpEntryFor(Context context) {
        if (context instanceof NullContext) {
            return;
        }
        this.parent = context.getCurEntry();
        if (this.parent != null) {
            ((CtEntry)this.parent).child = this;
        }
        context.setCurEntry(this);
    }

    @Override
    public void exit(int count, Object ... args) throws ErrorEntryFreeException {
        this.trueExit(count, args);
    }

    private void callExitHandlersAndCleanUp(Context ctx) {
        if (this.exitHandlers != null && !this.exitHandlers.isEmpty()) {
            for (BiConsumer biConsumer : this.exitHandlers) {
                try {
                    biConsumer.accept(ctx, this);
                }
                catch (Exception e) {
                    RecordLog.warn("Error occurred when invoking entry exit handler, current entry: " + this.resourceWrapper.getName(), e);
                }
            }
            this.exitHandlers = null;
        }
    }

    protected void exitForContext(Context context, int count, Object ... args) throws ErrorEntryFreeException {
        if (context != null) {
            if (context instanceof NullContext) {
                return;
            }
            if (context.getCurEntry() != this) {
                String curEntryNameInContext = context.getCurEntry() == null ? null : context.getCurEntry().getResourceWrapper().getName();
                CtEntry e = (CtEntry)context.getCurEntry();
                while (e != null) {
                    e.exit(count, args);
                    e = (CtEntry)e.parent;
                }
                String errorMessage = String.format("The order of entry exit can't be paired with the order of entry, current entry in context: <%s>, but expected: <%s>", curEntryNameInContext, this.resourceWrapper.getName());
                throw new ErrorEntryFreeException(errorMessage);
            }
            if (this.chain != null) {
                this.chain.exit(context, this.resourceWrapper, count, args);
            }
            this.callExitHandlersAndCleanUp(context);
            context.setCurEntry(this.parent);
            if (this.parent != null) {
                ((CtEntry)this.parent).child = null;
            }
            if (this.parent == null && ContextUtil.isDefaultContext(context)) {
                ContextUtil.exit();
            }
            this.clearEntryContext();
        }
    }

    protected void clearEntryContext() {
        this.context = null;
    }

    @Override
    public void whenTerminate(BiConsumer<Context, Entry> handler) {
        if (this.exitHandlers == null) {
            this.exitHandlers = new LinkedList();
        }
        this.exitHandlers.add(handler);
    }

    @Override
    protected Entry trueExit(int count, Object ... args) throws ErrorEntryFreeException {
        this.exitForContext(this.context, count, args);
        return this.parent;
    }

    @Override
    public Node getLastNode() {
        return this.parent == null ? null : this.parent.getCurNode();
    }
}

