/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core;

import kd.bos.armor.core.Entry;
import kd.bos.armor.core.context.Context;
import kd.bos.armor.core.context.ContextUtil;
import kd.bos.armor.core.context.NullContext;
import kd.bos.armor.core.slots.block.BlockException;
import kd.bos.armor.core.util.AssertUtil;
import kd.bos.armor.core.util.function.Predicate;

public class Tracer {
    protected static Class<? extends Throwable>[] traceClasses;
    protected static Class<? extends Throwable>[] ignoreClasses;
    protected static Predicate<Throwable> exceptionPredicate;

    protected Tracer() {
    }

    public static void trace(Throwable e) {
        Tracer.traceContext(e, ContextUtil.getContext());
    }

    @Deprecated
    public static void trace(Throwable e, int count) {
        Tracer.traceContext(e, count, ContextUtil.getContext());
    }

    public static void traceContext(Throwable e, Context context) {
        if (!Tracer.shouldTrace(e)) {
            return;
        }
        if (context == null || context instanceof NullContext) {
            return;
        }
        Tracer.traceEntryInternal(e, context.getCurEntry());
    }

    @Deprecated
    public static void traceContext(Throwable e, int count, Context context) {
        if (!Tracer.shouldTrace(e)) {
            return;
        }
        if (context == null || context instanceof NullContext) {
            return;
        }
        Tracer.traceEntryInternal(e, context.getCurEntry());
    }

    public static void traceEntry(Throwable e, Entry entry) {
        if (!Tracer.shouldTrace(e)) {
            return;
        }
        Tracer.traceEntryInternal(e, entry);
    }

    private static void traceEntryInternal(Throwable e, Entry entry) {
        if (entry == null) {
            return;
        }
        entry.setError(e);
    }

    public static Class<? extends Throwable>[] getExceptionsToTrace() {
        return traceClasses;
    }

    @SafeVarargs
    public static void setExceptionsToTrace(Class<? extends Throwable> ... traceClasses) {
        Tracer.checkNotNull(traceClasses);
        Tracer.traceClasses = traceClasses;
    }

    public static Class<? extends Throwable>[] getExceptionsToIgnore() {
        return ignoreClasses;
    }

    @SafeVarargs
    public static void setExceptionsToIgnore(Class<? extends Throwable> ... ignoreClasses) {
        Tracer.checkNotNull(ignoreClasses);
        Tracer.ignoreClasses = ignoreClasses;
    }

    public static Predicate<? extends Throwable> getExceptionPredicate() {
        return exceptionPredicate;
    }

    public static void setExceptionPredicate(Predicate<Throwable> exceptionPredicate) {
        AssertUtil.notNull(exceptionPredicate, "exception predicate must not be null");
        Tracer.exceptionPredicate = exceptionPredicate;
    }

    private static void checkNotNull(Class<? extends Throwable>[] classes) {
        AssertUtil.notNull(classes, "trace or ignore classes must not be null");
        for (Class<? extends Throwable> clazz : classes) {
            AssertUtil.notNull(clazz, "trace or ignore classes must not be null");
        }
    }

    protected static boolean shouldTrace(Throwable t) {
        if (t == null || t instanceof BlockException) {
            return false;
        }
        if (exceptionPredicate != null) {
            return exceptionPredicate.test(t);
        }
        if (ignoreClasses != null) {
            for (Class<? extends Throwable> clazz : ignoreClasses) {
                if (clazz == null || !clazz.isAssignableFrom(t.getClass())) continue;
                return false;
            }
        }
        if (traceClasses != null) {
            for (Class<? extends Throwable> clazz : traceClasses) {
                if (clazz == null || !clazz.isAssignableFrom(t.getClass())) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

