/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.metric.extension.callback;

import kd.bos.armor.core.Entry;
import kd.bos.armor.core.context.Context;
import kd.bos.armor.core.metric.extension.AdvancedMetricExtension;
import kd.bos.armor.core.metric.extension.MetricExtension;
import kd.bos.armor.core.metric.extension.MetricExtensionProvider;
import kd.bos.armor.core.slotchain.ProcessorSlotExitCallback;
import kd.bos.armor.core.slotchain.ResourceWrapper;
import kd.bos.armor.core.util.TimeUtil;

public class MetricExitCallback
implements ProcessorSlotExitCallback {
    @Override
    public void onExit(Context context, ResourceWrapper rw, int acquireCount, Object ... args) {
        Entry curEntry = context.getCurEntry();
        if (curEntry == null) {
            return;
        }
        for (MetricExtension m : MetricExtensionProvider.getMetricExtensions()) {
            if (curEntry.getBlockError() != null) continue;
            String resource = rw.getName();
            Throwable ex = curEntry.getError();
            long completeTime = curEntry.getCompleteTimestamp();
            if (completeTime <= 0L) {
                completeTime = TimeUtil.currentTimeMillis();
            }
            long rt = completeTime - curEntry.getCreateTimestamp();
            if (m instanceof AdvancedMetricExtension) {
                ((AdvancedMetricExtension)m).onComplete(rw, rt, acquireCount, args);
                if (ex == null) continue;
                ((AdvancedMetricExtension)m).onError(rw, ex, acquireCount, args);
                continue;
            }
            m.addRt(resource, rt, args);
            m.addSuccess(resource, acquireCount, args);
            m.decreaseThreadNum(resource, args);
            if (null == ex) continue;
            m.addException(resource, acquireCount, ex);
        }
    }
}

