/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.node;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.armor.core.node.Node;
import kd.bos.armor.core.node.StatisticNode;
import kd.bos.armor.core.util.AssertUtil;

public class ClusterNode
extends StatisticNode {
    private final String tenantId;
    private final String name;
    private final int resourceType;
    private final ReentrantLock lock = new ReentrantLock();
    private Map<String, StatisticNode> originCountMap = new HashMap<String, StatisticNode>();

    public ClusterNode(String name) {
        this(name, 0);
    }

    public ClusterNode(String name, int resourceType) {
        AssertUtil.notEmpty(name, "name cannot be empty");
        this.tenantId = "default";
        this.name = name;
        this.resourceType = resourceType;
    }

    public ClusterNode(String tenantId, String name, int resourceType) {
        AssertUtil.notEmpty(name, "name cannot be empty");
        this.tenantId = tenantId;
        this.name = name;
        this.resourceType = resourceType;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getName() {
        return this.name;
    }

    public int getResourceType() {
        return this.resourceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getOrCreateOriginNode(String origin) {
        StatisticNode statisticNode = this.originCountMap.get(origin);
        if (statisticNode == null) {
            this.lock.lock();
            try {
                statisticNode = this.originCountMap.get(origin);
                if (statisticNode == null) {
                    statisticNode = new StatisticNode();
                    HashMap<String, StatisticNode> newMap = new HashMap<String, StatisticNode>(this.originCountMap.size() + 1);
                    newMap.putAll(this.originCountMap);
                    newMap.put(origin, statisticNode);
                    this.originCountMap = newMap;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return statisticNode;
    }

    public Map<String, StatisticNode> getOriginCountMap() {
        return this.originCountMap;
    }
}

