/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.armor.core.log.RecordLog;
import kd.bos.armor.core.property.ArmorProperty;
import kd.bos.armor.core.property.PropertyListener;
import kd.bos.armor.core.slots.block.AbstractRule;
import kd.bos.instance.Instance;

public class DynamicArmorProperty<T>
implements ArmorProperty<T> {
    protected Set<PropertyListener<T>> listeners = Collections.synchronizedSet(new HashSet());
    private T value = null;

    public DynamicArmorProperty() {
    }

    public DynamicArmorProperty(T value) {
        this.value = value;
    }

    @Override
    public void addListener(PropertyListener<T> listener) {
        this.listeners.add(listener);
        listener.configLoad(this.value);
    }

    @Override
    public void removeListener(PropertyListener<T> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean updateValue(T newValue) {
        if (null != newValue) {
            ArrayList<AbstractRule> list = new ArrayList<AbstractRule>(8);
            for (AbstractRule rule : (List)newValue) {
                if (!Instance.getAppName().equals(rule.getAppName()) && !"default".equals(rule.getAppName())) continue;
                list.add(rule);
            }
            newValue = list.size() > 0 ? list : null;
        }
        if (this.isEqual(this.value, newValue)) {
            return false;
        }
        RecordLog.info("[DynamicArmorProperty] Config will be updated to: {}", newValue);
        this.value = newValue;
        for (PropertyListener<T> listener : this.listeners) {
            listener.configUpdate(newValue);
        }
        return true;
    }

    private boolean isEqual(T oldValue, T newValue) {
        if (oldValue == null && newValue == null) {
            return true;
        }
        if (oldValue == null) {
            return false;
        }
        return oldValue.equals(newValue);
    }

    public void close() {
        this.listeners.clear();
    }
}

