/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.slotchain;

import kd.bos.armor.core.log.RecordLog;
import kd.bos.armor.core.slotchain.ProcessorSlotChain;
import kd.bos.armor.core.slotchain.SlotChainBuilder;
import kd.bos.armor.core.slots.DefaultSlotChainBuilder;
import kd.bos.armor.core.util.SpiLoader;

public final class SlotChainProvider {
    private static volatile SlotChainBuilder slotChainBuilder;

    private SlotChainProvider() {
    }

    public static ProcessorSlotChain newSlotChain() {
        return SlotChainProvider.getSlotChainBuilder().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SlotChainBuilder getSlotChainBuilder() {
        if (slotChainBuilder != null) return slotChainBuilder;
        Class<SlotChainProvider> clazz = SlotChainProvider.class;
        synchronized (SlotChainProvider.class) {
            if (slotChainBuilder == null) {
                slotChainBuilder = SpiLoader.loadFirstInstanceOrDefault(SlotChainBuilder.class, DefaultSlotChainBuilder.class);
            }
            if (slotChainBuilder == null) {
                RecordLog.warn("[SlotChainProvider] Wrong state when resolving slot chain builder, using default", new Object[0]);
                slotChainBuilder = new DefaultSlotChainBuilder();
            } else {
                RecordLog.info("[SlotChainProvider] Global slot chain builder resolved: {}", slotChainBuilder.getClass().getCanonicalName());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return slotChainBuilder;
        }
    }
}

