/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.slots.block.degrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.armor.core.log.RecordLog;
import kd.bos.armor.core.property.ArmorProperty;
import kd.bos.armor.core.property.DynamicArmorProperty;
import kd.bos.armor.core.property.PropertyListener;
import kd.bos.armor.core.slots.block.ArmorSlotUtil;
import kd.bos.armor.core.slots.block.degrade.DegradeRule;
import kd.bos.armor.core.slots.block.degrade.circuitbreaker.CircuitBreaker;
import kd.bos.armor.core.slots.block.degrade.circuitbreaker.ExceptionCircuitBreaker;
import kd.bos.armor.core.slots.block.degrade.circuitbreaker.ResponseTimeCircuitBreaker;
import kd.bos.armor.core.util.AssertUtil;
import kd.bos.armor.core.util.StringUtil;
import kd.bos.armor.transport.datasource.ReadableDataSource;

public final class DegradeRuleManager {
    private static final RulePropertyListener LISTENER = new RulePropertyListener();
    private static volatile Map<String, List<CircuitBreaker>> circuitBreakers = new HashMap<String, List<CircuitBreaker>>();
    private static final AtomicReference<List<String>> degradeRuleKeys = new AtomicReference();
    private static volatile Map<String, Set<DegradeRule>> ruleMap = new HashMap<String, Set<DegradeRule>>();
    private static ArmorProperty<List<DegradeRule>> currentProperty = new DynamicArmorProperty<List<DegradeRule>>();
    private static ReadableDataSource<String, List<DegradeRule>> dataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDataSource(ReadableDataSource<String, List<DegradeRule>> degradeRuleDataSource) {
        AssertUtil.notNull(degradeRuleDataSource, "property cannot be null");
        RulePropertyListener rulePropertyListener = LISTENER;
        synchronized (rulePropertyListener) {
            dataSource = degradeRuleDataSource;
            RecordLog.info("[DegradeRuleManager] Registering new property to degrade rule manager", new Object[0]);
            currentProperty.removeListener(LISTENER);
            degradeRuleDataSource.getProperty().addListener(LISTENER);
            currentProperty = degradeRuleDataSource.getProperty();
        }
    }

    public static ReadableDataSource<String, List<DegradeRule>> getDataSource() {
        return dataSource;
    }

    static Map<String, List<CircuitBreaker>> getCircuitBreakerMap() {
        return circuitBreakers;
    }

    static List<String> getCircuitBreakerKeyList() {
        return degradeRuleKeys.get();
    }

    static List<CircuitBreaker> getCircuitBreakers(String resourceName) {
        return circuitBreakers.get(resourceName);
    }

    public static boolean hasConfig(String resource) {
        if (resource == null) {
            return false;
        }
        return circuitBreakers.containsKey(resource);
    }

    public static List<DegradeRule> getRules() {
        ArrayList<DegradeRule> rules = new ArrayList<DegradeRule>();
        for (Map.Entry<String, Set<DegradeRule>> entry : ruleMap.entrySet()) {
            rules.addAll((Collection<DegradeRule>)entry.getValue());
        }
        return rules;
    }

    public static Set<DegradeRule> getRulesOfResource(String resource) {
        AssertUtil.assertNotBlank(resource, "resource name cannot be blank");
        return ruleMap.get(resource);
    }

    public static void loadRules(List<DegradeRule> rules) {
        try {
            currentProperty.updateValue(rules);
        }
        catch (Throwable e) {
            RecordLog.error("[DegradeRuleManager] Unexpected error when loading degrade rules", e);
        }
    }

    public static boolean setRulesForResource(String resourceName, Set<DegradeRule> rules) {
        AssertUtil.notEmpty(resourceName, "resourceName cannot be empty");
        try {
            HashMap<String, Set<DegradeRule>> newRuleMap = new HashMap<String, Set<DegradeRule>>(ruleMap);
            if (rules == null) {
                newRuleMap.remove(resourceName);
            } else {
                HashSet<DegradeRule> newSet = new HashSet<DegradeRule>();
                for (DegradeRule rule : rules) {
                    if (!DegradeRuleManager.isValidRule(rule) || !resourceName.equals(rule.getResource())) continue;
                    newSet.add(rule);
                }
                newRuleMap.put(resourceName, newSet);
            }
            ArrayList allRules = new ArrayList();
            for (Set set : newRuleMap.values()) {
                allRules.addAll(set);
            }
            return currentProperty.updateValue(allRules);
        }
        catch (Throwable e) {
            RecordLog.error("[DegradeRuleManager] Unexpected error when setting circuit breaking rules for resource: " + resourceName, e);
            return false;
        }
    }

    private static CircuitBreaker getExistingSameCbOrNew(DegradeRule rule) {
        List<CircuitBreaker> cbs = DegradeRuleManager.getCircuitBreakers(rule.getResource());
        if (cbs == null || cbs.isEmpty()) {
            return DegradeRuleManager.newCircuitBreakerFrom(rule);
        }
        for (CircuitBreaker cb : cbs) {
            if (!rule.equals(cb.getRule())) continue;
            return cb;
        }
        return DegradeRuleManager.newCircuitBreakerFrom(rule);
    }

    private static CircuitBreaker newCircuitBreakerFrom(DegradeRule rule) {
        switch (rule.getGrade()) {
            case 0: {
                return new ResponseTimeCircuitBreaker(rule);
            }
            case 1: 
            case 2: {
                return new ExceptionCircuitBreaker(rule);
            }
        }
        return null;
    }

    public static boolean isValidRule(DegradeRule rule) {
        boolean baseValid;
        boolean bl = baseValid = rule != null && !StringUtil.isBlank(rule.getResource()) && rule.getCount() >= 0.0 && rule.getTimeWindow() > 0;
        if (!baseValid) {
            return false;
        }
        if (rule.getMinRequestAmount() <= 0 || rule.getStatIntervalMs() <= 0) {
            return false;
        }
        switch (rule.getGrade()) {
            case 0: {
                return rule.getSlowRatioThreshold() >= 0.0 && rule.getSlowRatioThreshold() <= 1.0;
            }
            case 1: {
                return rule.getCount() <= 1.0;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    static {
        currentProperty.addListener(LISTENER);
    }

    private static class RulePropertyListener
    implements PropertyListener<List<DegradeRule>> {
        private RulePropertyListener() {
        }

        private synchronized void reloadFrom(List<DegradeRule> list) {
            Map cbs = this.buildCircuitBreakers(list);
            HashMap rm = new HashMap(cbs.size());
            for (Map.Entry<String, List<CircuitBreaker>> e : cbs.entrySet()) {
                assert (e.getValue() != null && !e.getValue().isEmpty());
                HashSet<DegradeRule> rules = new HashSet<DegradeRule>(e.getValue().size());
                for (CircuitBreaker cb : e.getValue()) {
                    rules.add(cb.getRule());
                }
                rm.put(e.getKey(), rules);
            }
            List<String> degradeRuleKeyList = ArmorSlotUtil.sortRuleMapKeys(cbs);
            degradeRuleKeys.set(degradeRuleKeyList);
            circuitBreakers = cbs;
            ruleMap = rm;
        }

        @Override
        public void configUpdate(List<DegradeRule> conf) {
            this.reloadFrom(conf);
        }

        @Override
        public void configLoad(List<DegradeRule> conf) {
            this.reloadFrom(conf);
        }

        private Map<String, List<CircuitBreaker>> buildCircuitBreakers(List<DegradeRule> list) {
            HashMap<String, List<CircuitBreaker>> cbMap = new HashMap<String, List<CircuitBreaker>>(8);
            if (list == null || list.isEmpty()) {
                return cbMap;
            }
            for (DegradeRule rule : list) {
                CircuitBreaker cb;
                if (!DegradeRuleManager.isValidRule(rule)) {
                    RecordLog.warn("[DegradeRuleManager] Ignoring invalid rule when loading new rules: {}", rule);
                    continue;
                }
                if (StringUtil.isEmpty(rule.getTenantId())) {
                    rule.setTenantId("default");
                }
                if (StringUtil.isBlank(rule.getLimitApp())) {
                    rule.setLimitApp("default");
                }
                if ((cb = DegradeRuleManager.getExistingSameCbOrNew(rule)) == null) {
                    RecordLog.warn("[DegradeRuleManager] Unknown circuit breaking strategy, ignoring: {}", rule);
                    continue;
                }
                String resourceName = rule.getResource();
                ArrayList<CircuitBreaker> cbList = (ArrayList<CircuitBreaker>)cbMap.get(resourceName);
                if (cbList == null) {
                    cbList = new ArrayList<CircuitBreaker>();
                    cbMap.put(resourceName, cbList);
                }
                cbList.add(cb);
            }
            return cbMap;
        }
    }
}

