/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.slots.block.degrade;

import java.util.List;
import java.util.Map;
import kd.bos.armor.core.Entry;
import kd.bos.armor.core.context.Context;
import kd.bos.armor.core.node.DefaultNode;
import kd.bos.armor.core.slotchain.AbstractLinkedProcessorSlot;
import kd.bos.armor.core.slotchain.ResourceWrapper;
import kd.bos.armor.core.slots.block.ArmorSlotUtil;
import kd.bos.armor.core.slots.block.BlockException;
import kd.bos.armor.core.slots.block.degrade.DegradeException;
import kd.bos.armor.core.slots.block.degrade.DegradeRuleManager;
import kd.bos.armor.core.slots.block.degrade.circuitbreaker.CircuitBreaker;
import kd.bos.armor.core.spi.SpiOrder;

@SpiOrder(value=-1000)
public class DegradeSlot
extends AbstractLinkedProcessorSlot<DefaultNode> {
    @Override
    public void entry(Context context, ResourceWrapper resourceWrapper, DefaultNode node, int count, boolean prioritized, Object ... args) throws Throwable {
        this.performChecking(context, resourceWrapper);
        this.fireEntry(context, resourceWrapper, node, count, prioritized, args);
    }

    void performChecking(Context context, ResourceWrapper r) throws BlockException {
        Map circuitBreakerMap = DegradeRuleManager.getCircuitBreakerMap();
        List<CircuitBreaker> circuitBreakers = ArmorSlotUtil.getWildcardRules(r.getName(), DegradeRuleManager.getCircuitBreakerKeyList(), circuitBreakerMap);
        if (circuitBreakers == null || circuitBreakers.isEmpty()) {
            return;
        }
        for (CircuitBreaker cb : circuitBreakers) {
            if (cb.tryPass(context)) continue;
            throw new DegradeException(cb.getRule().getLimitApp(), cb.getRule());
        }
    }

    @Override
    public void exit(Context context, ResourceWrapper r, int count, Object ... args) {
        Entry curEntry = context.getCurEntry();
        if (curEntry.getBlockError() != null) {
            this.fireExit(context, r, count, args);
            return;
        }
        Map circuitBreakerMap = DegradeRuleManager.getCircuitBreakerMap();
        List<CircuitBreaker> circuitBreakers = ArmorSlotUtil.getWildcardRules(r.getName(), DegradeRuleManager.getCircuitBreakerKeyList(), circuitBreakerMap);
        if (circuitBreakers == null || circuitBreakers.isEmpty()) {
            this.fireExit(context, r, count, args);
            return;
        }
        if (curEntry.getBlockError() == null) {
            for (CircuitBreaker circuitBreaker : circuitBreakers) {
                circuitBreaker.onRequestComplete(context);
            }
        }
        this.fireExit(context, r, count, args);
    }
}

