/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.slots.block.degrade.circuitbreaker;

import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.armor.core.Entry;
import kd.bos.armor.core.context.Context;
import kd.bos.armor.core.slots.block.degrade.DegradeRule;
import kd.bos.armor.core.slots.block.degrade.DegradeRuleManager;
import kd.bos.armor.core.slots.block.degrade.circuitbreaker.CircuitBreaker;
import kd.bos.armor.core.slots.block.degrade.circuitbreaker.CircuitBreakerStateChangeObserver;
import kd.bos.armor.core.slots.block.degrade.circuitbreaker.EventObserverRegistry;
import kd.bos.armor.core.util.AssertUtil;
import kd.bos.armor.core.util.StringUtil;
import kd.bos.armor.core.util.TimeUtil;
import kd.bos.armor.core.util.function.BiConsumer;

public abstract class AbstractCircuitBreaker
implements CircuitBreaker {
    protected final DegradeRule rule;
    protected final int recoveryTimeoutMs;
    protected final AtomicReference<CircuitBreaker.State> currentState = new AtomicReference<CircuitBreaker.State>(CircuitBreaker.State.CLOSED);
    private final EventObserverRegistry observerRegistry;
    protected volatile long nextRetryTimestamp;

    public AbstractCircuitBreaker(DegradeRule rule) {
        this(rule, EventObserverRegistry.getInstance());
    }

    AbstractCircuitBreaker(DegradeRule rule, EventObserverRegistry observerRegistry) {
        AssertUtil.notNull(observerRegistry, "observerRegistry cannot be null");
        if (!DegradeRuleManager.isValidRule(rule)) {
            throw new IllegalArgumentException("Invalid DegradeRule: " + rule);
        }
        this.observerRegistry = observerRegistry;
        this.rule = rule;
        this.recoveryTimeoutMs = rule.getTimeWindow() * 1000;
    }

    @Override
    public DegradeRule getRule() {
        return this.rule;
    }

    @Override
    public CircuitBreaker.State currentState() {
        return this.currentState.get();
    }

    @Override
    public boolean tryPass(Context context) {
        if (!this.isHaveCurrentTenantIdRule(context)) {
            return true;
        }
        boolean isHaveRule = false;
        String limitApp = this.rule.getLimitApp();
        String origin = context.getOrigin();
        if ("default".equals(limitApp)) {
            isHaveRule = true;
        } else {
            String[] appIds;
            for (String appId : appIds = limitApp.split(",")) {
                if (!appId.toLowerCase(Locale.ENGLISH).trim().equals(origin.toLowerCase(Locale.ENGLISH))) continue;
                isHaveRule = true;
                break;
            }
        }
        if (!isHaveRule) {
            return true;
        }
        if (this.currentState.get() == CircuitBreaker.State.CLOSED) {
            return true;
        }
        if (this.currentState.get() == CircuitBreaker.State.OPEN) {
            return this.retryTimeoutArrived() && this.fromOpenToHalfOpen(context);
        }
        return false;
    }

    private boolean isHaveCurrentTenantIdRule(Context context) {
        String[] tenantIds;
        String tenantId = this.rule.getTenantId();
        if (StringUtil.isEmpty(tenantId) || "default".equals(tenantId)) {
            return true;
        }
        String currentTenantId = context.getTenantId();
        for (String tempTenantId : tenantIds = tenantId.split(",")) {
            if (!tempTenantId.toLowerCase(Locale.ENGLISH).trim().equals(currentTenantId.toLowerCase(Locale.ENGLISH).trim())) continue;
            return true;
        }
        return false;
    }

    abstract void resetStat();

    protected boolean retryTimeoutArrived() {
        return TimeUtil.currentTimeMillis() >= this.nextRetryTimestamp;
    }

    protected void updateNextRetryTimestamp() {
        this.nextRetryTimestamp = TimeUtil.currentTimeMillis() + (long)this.recoveryTimeoutMs;
    }

    protected boolean fromCloseToOpen(double snapshotValue) {
        CircuitBreaker.State prev = CircuitBreaker.State.CLOSED;
        if (this.currentState.compareAndSet(prev, CircuitBreaker.State.OPEN)) {
            this.updateNextRetryTimestamp();
            this.notifyObservers(prev, CircuitBreaker.State.OPEN, snapshotValue);
            return true;
        }
        return false;
    }

    protected boolean fromOpenToHalfOpen(Context context) {
        if (this.currentState.compareAndSet(CircuitBreaker.State.OPEN, CircuitBreaker.State.HALF_OPEN)) {
            this.notifyObservers(CircuitBreaker.State.OPEN, CircuitBreaker.State.HALF_OPEN, null);
            Entry entry = context.getCurEntry();
            entry.whenTerminate(new BiConsumer<Context, Entry>(){

                @Override
                public void accept(Context context, Entry entry) {
                    if (entry.getBlockError() != null) {
                        AbstractCircuitBreaker.this.currentState.compareAndSet(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.OPEN);
                        AbstractCircuitBreaker.this.notifyObservers(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.OPEN, 1.0);
                    }
                }
            });
            return true;
        }
        return false;
    }

    private void notifyObservers(CircuitBreaker.State prevState, CircuitBreaker.State newState, Double snapshotValue) {
        for (CircuitBreakerStateChangeObserver observer : this.observerRegistry.getStateChangeObservers()) {
            observer.onStateChange(prevState, newState, this.rule, snapshotValue);
        }
    }

    protected boolean fromHalfOpenToOpen(double snapshotValue) {
        if (this.currentState.compareAndSet(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.OPEN)) {
            this.updateNextRetryTimestamp();
            this.notifyObservers(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.OPEN, snapshotValue);
            return true;
        }
        return false;
    }

    protected boolean fromHalfOpenToClose() {
        if (this.currentState.compareAndSet(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.CLOSED)) {
            this.resetStat();
            this.notifyObservers(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.CLOSED, null);
            return true;
        }
        return false;
    }

    protected void transformToOpen(double triggerValue) {
        CircuitBreaker.State cs = this.currentState.get();
        switch (cs) {
            case CLOSED: {
                this.fromCloseToOpen(triggerValue);
                break;
            }
            case HALF_OPEN: {
                this.fromHalfOpenToOpen(triggerValue);
                break;
            }
        }
    }
}

