/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.slots.block.degrade.circuitbreaker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.armor.core.slots.block.degrade.circuitbreaker.CircuitBreakerStateChangeObserver;
import kd.bos.armor.core.util.AssertUtil;

public class EventObserverRegistry {
    private final Map<String, CircuitBreakerStateChangeObserver> stateChangeObserverMap = new HashMap<String, CircuitBreakerStateChangeObserver>();

    EventObserverRegistry() {
    }

    public static EventObserverRegistry getInstance() {
        return InstanceHolder.instance;
    }

    public void addStateChangeObserver(String name, CircuitBreakerStateChangeObserver observer) {
        AssertUtil.notNull(name, "name cannot be null");
        AssertUtil.notNull(observer, "observer cannot be null");
        this.stateChangeObserverMap.put(name, observer);
    }

    public boolean removeStateChangeObserver(String name) {
        AssertUtil.notNull(name, "name cannot be null");
        return this.stateChangeObserverMap.remove(name) != null;
    }

    public List<CircuitBreakerStateChangeObserver> getStateChangeObservers() {
        return new ArrayList<CircuitBreakerStateChangeObserver>(this.stateChangeObserverMap.values());
    }

    private static class InstanceHolder {
        private static EventObserverRegistry instance = new EventObserverRegistry();

        private InstanceHolder() {
        }
    }
}

