/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.slots.block.flow;

import kd.bos.armor.core.node.IntervalProperty;
import kd.bos.armor.core.node.SampleCountProperty;
import kd.bos.armor.core.slots.block.AbstractRule;
import kd.bos.armor.core.slots.block.flow.ClusterFlowConfig;
import kd.bos.armor.core.slots.block.flow.TrafficShapingController;

public class FlowRule
extends AbstractRule {
    private int grade = 1;
    private int count;
    private int strategy = 0;
    private String refResource;
    private int controlBehavior = 0;
    private int warmUpPeriodSec = 10;
    private int maxQueueingTimeMs = 500;
    private int statIntervalMs = IntervalProperty.INTERVAL;
    private int sampleCount = SampleCountProperty.SAMPLE_COUNT;
    private boolean clusterMode;
    private ClusterFlowConfig clusterConfig;
    private TrafficShapingController controller;

    public FlowRule() {
        this.setLimitApp("default");
    }

    public FlowRule(String resourceName) {
        this.setResource(resourceName);
        this.setLimitApp("default");
    }

    public int getControlBehavior() {
        return this.controlBehavior;
    }

    public FlowRule setControlBehavior(int controlBehavior) {
        this.controlBehavior = controlBehavior;
        return this;
    }

    public int getMaxQueueingTimeMs() {
        return this.maxQueueingTimeMs;
    }

    public FlowRule setMaxQueueingTimeMs(int maxQueueingTimeMs) {
        this.maxQueueingTimeMs = maxQueueingTimeMs;
        return this;
    }

    public int getStatIntervalMs() {
        return this.statIntervalMs;
    }

    public void setStatIntervalMs(int statIntervalMs) {
        this.statIntervalMs = statIntervalMs;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public void setSampleCount(int sampleCount) {
        this.sampleCount = sampleCount;
    }

    TrafficShapingController getRater() {
        return this.controller;
    }

    FlowRule setRater(TrafficShapingController rater) {
        this.controller = rater;
        return this;
    }

    public int getWarmUpPeriodSec() {
        return this.warmUpPeriodSec;
    }

    public FlowRule setWarmUpPeriodSec(int warmUpPeriodSec) {
        this.warmUpPeriodSec = warmUpPeriodSec;
        return this;
    }

    public int getGrade() {
        return this.grade;
    }

    public FlowRule setGrade(int grade) {
        this.grade = grade;
        return this;
    }

    public int getCount() {
        return this.count;
    }

    public FlowRule setCount(int count) {
        this.count = count;
        return this;
    }

    public int getStrategy() {
        return this.strategy;
    }

    public FlowRule setStrategy(int strategy) {
        this.strategy = strategy;
        return this;
    }

    public String getRefResource() {
        return this.refResource;
    }

    public FlowRule setRefResource(String refResource) {
        this.refResource = refResource;
        return this;
    }

    public boolean isClusterMode() {
        return this.clusterMode;
    }

    public FlowRule setClusterMode(boolean clusterMode) {
        this.clusterMode = clusterMode;
        return this;
    }

    public ClusterFlowConfig getClusterConfig() {
        return this.clusterConfig;
    }

    public FlowRule setClusterConfig(ClusterFlowConfig clusterConfig) {
        this.clusterConfig = clusterConfig;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FlowRule rule = (FlowRule)o;
        if (this.grade != rule.grade) {
            return false;
        }
        if (Double.compare(rule.count, this.count) != 0) {
            return false;
        }
        if (this.strategy != rule.strategy) {
            return false;
        }
        if (this.controlBehavior != rule.controlBehavior) {
            return false;
        }
        if (this.warmUpPeriodSec != rule.warmUpPeriodSec) {
            return false;
        }
        if (this.maxQueueingTimeMs != rule.maxQueueingTimeMs) {
            return false;
        }
        if (this.statIntervalMs != rule.statIntervalMs) {
            return false;
        }
        if (this.clusterMode != rule.clusterMode) {
            return false;
        }
        if (this.refResource != null ? !this.refResource.equals(rule.refResource) : rule.refResource != null) {
            return false;
        }
        return this.clusterConfig != null ? this.clusterConfig.equals(rule.clusterConfig) : rule.clusterConfig == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.grade;
        long temp = Double.doubleToLongBits(this.count);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.strategy;
        result = 31 * result + (this.refResource != null ? this.refResource.hashCode() : 0);
        result = 31 * result + this.controlBehavior;
        result = 31 * result + this.warmUpPeriodSec;
        result = 31 * result + this.maxQueueingTimeMs;
        result = 31 * result + this.statIntervalMs;
        result = 31 * result + (this.clusterMode ? 1 : 0);
        result = 31 * result + (this.clusterConfig != null ? this.clusterConfig.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "FlowRule{resource=" + this.getResource() + ", limitApp=" + this.getLimitApp() + ", tenantId=" + this.getTenantId() + ", grade=" + this.grade + ", count=" + this.count + ", strategy=" + this.strategy + ", refResource=" + this.refResource + ", controlBehavior=" + this.controlBehavior + ", warmUpPeriodSec=" + this.warmUpPeriodSec + ", maxQueueingTimeMs=" + this.maxQueueingTimeMs + ", statIntervalMs=" + this.statIntervalMs + ", clusterMode=" + this.clusterMode + ", clusterConfig=" + this.clusterConfig + ", controller=" + this.controller + '}';
    }
}

