/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.slots.block.flow;

import java.util.Collection;
import java.util.Locale;
import kd.bos.armor.core.context.Context;
import kd.bos.armor.core.node.ClusterNode;
import kd.bos.armor.core.node.DefaultNode;
import kd.bos.armor.core.node.IntervalProperty;
import kd.bos.armor.core.node.Node;
import kd.bos.armor.core.node.SampleCountProperty;
import kd.bos.armor.core.slotchain.ResourceWrapper;
import kd.bos.armor.core.slots.block.BlockException;
import kd.bos.armor.core.slots.block.flow.FlowException;
import kd.bos.armor.core.slots.block.flow.FlowRule;
import kd.bos.armor.core.slots.block.flow.FlowRuleManager;
import kd.bos.armor.core.slots.clusterbuilder.ClusterBuilderSlot;
import kd.bos.armor.core.util.StringUtil;
import kd.bos.armor.core.util.function.Function;

public class FlowRuleChecker {
    private static boolean passLocalCheck(FlowRule rule, Context context, DefaultNode node, int acquireCount, boolean prioritized) {
        if (!FlowRuleChecker.isHaveCurrentTenantIdRule(rule, context)) {
            return true;
        }
        Node selectedNode = FlowRuleChecker.selectNodeByRequesterAndStrategy(rule, context, node);
        if (selectedNode == null) {
            return true;
        }
        return rule.getRater().canPass(selectedNode, acquireCount, prioritized);
    }

    static Node selectReferenceNode(FlowRule rule, Context context, DefaultNode node) {
        String refResource = rule.getRefResource();
        int strategy = rule.getStrategy();
        if (StringUtil.isEmpty(refResource)) {
            return null;
        }
        if (strategy == 1) {
            return ClusterBuilderSlot.getClusterNode(refResource);
        }
        if (strategy == 2) {
            if (!refResource.equals(context.getName())) {
                return null;
            }
            return node;
        }
        return null;
    }

    private static boolean isHaveCurrentTenantIdRule(FlowRule rule, Context context) {
        String[] tenantIds;
        String tenantId = rule.getTenantId();
        if (StringUtil.isEmpty(tenantId) || "default".equals(tenantId)) {
            return true;
        }
        String currentTenantId = context.getTenantId();
        for (String tempTenantId : tenantIds = tenantId.split(",")) {
            if (!tempTenantId.toLowerCase(Locale.ENGLISH).trim().equals(currentTenantId.toLowerCase(Locale.ENGLISH).trim())) continue;
            return true;
        }
        return false;
    }

    private static boolean filterAppId(String limitApp, String origin) {
        String[] appIds;
        boolean isHaveRule = false;
        for (String appId : appIds = limitApp.split(",")) {
            if (!appId.toLowerCase().trim().equals(origin)) continue;
            isHaveRule = true;
            break;
        }
        return isHaveRule;
    }

    private static boolean filterOrigin(String origin) {
        return !"default".equals(origin) && !"other".equals(origin);
    }

    static Node selectNodeByRequesterAndStrategy(FlowRule rule, Context context, DefaultNode node) {
        String limitApp = rule.getLimitApp();
        int strategy = rule.getStrategy();
        String origin = context.getOrigin();
        if ("default".equals(limitApp) || FlowRuleChecker.filterAppId(limitApp, origin)) {
            if (strategy == 0) {
                ClusterNode clusterNode = node.getClusterNode();
                if (node.getInterval() != rule.getStatIntervalMs()) {
                    node.reset(rule.getSampleCount(), rule.getStatIntervalMs());
                    node.getClusterNode().reset(rule.getSampleCount(), rule.getStatIntervalMs());
                }
                return clusterNode;
            }
            return FlowRuleChecker.selectReferenceNode(rule, context, node);
        }
        if ("other".equals(limitApp) && FlowRuleManager.isOtherOrigin(origin, rule.getResource())) {
            if (strategy == 0) {
                return context.getOriginNode();
            }
            return FlowRuleChecker.selectReferenceNode(rule, context, node);
        }
        return null;
    }

    private static boolean fallbackToLocalOrPass(FlowRule rule, Context context, DefaultNode node, int acquireCount, boolean prioritized) {
        if (rule.getClusterConfig().isFallbackToLocalWhenFail()) {
            return FlowRuleChecker.passLocalCheck(rule, context, node, acquireCount, prioritized);
        }
        return true;
    }

    public void checkFlow(Function<String, Collection<FlowRule>> ruleProvider, ResourceWrapper resource, Context context, DefaultNode node, int count, boolean prioritized) throws BlockException {
        if (ruleProvider == null || resource == null) {
            return;
        }
        Collection<FlowRule> rules = ruleProvider.apply(resource.getName());
        if (rules != null) {
            for (FlowRule rule : rules) {
                if (this.canPassCheck(rule, context, node, count, prioritized)) continue;
                throw new FlowException(rule.getLimitApp(), rule);
            }
        } else if (node.getInterval() == 0) {
            node.reset(SampleCountProperty.SAMPLE_COUNT, IntervalProperty.INTERVAL);
            node.getClusterNode().reset(SampleCountProperty.SAMPLE_COUNT, IntervalProperty.INTERVAL);
        }
    }

    public boolean canPassCheck(FlowRule rule, Context context, DefaultNode node, int acquireCount, boolean prioritized) {
        String limitApp = rule.getLimitApp();
        if (limitApp == null) {
            return true;
        }
        return FlowRuleChecker.passLocalCheck(rule, context, node, acquireCount, prioritized);
    }
}

