/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.slots.block.flow;

import java.util.Collection;
import java.util.Map;
import kd.bos.armor.core.context.Context;
import kd.bos.armor.core.node.DefaultNode;
import kd.bos.armor.core.slotchain.AbstractLinkedProcessorSlot;
import kd.bos.armor.core.slotchain.ResourceWrapper;
import kd.bos.armor.core.slots.block.ArmorSlotUtil;
import kd.bos.armor.core.slots.block.BlockException;
import kd.bos.armor.core.slots.block.flow.FlowRule;
import kd.bos.armor.core.slots.block.flow.FlowRuleChecker;
import kd.bos.armor.core.slots.block.flow.FlowRuleManager;
import kd.bos.armor.core.spi.SpiOrder;
import kd.bos.armor.core.util.AssertUtil;
import kd.bos.armor.core.util.function.Function;

@SpiOrder(value=-2000)
public class FlowSlot
extends AbstractLinkedProcessorSlot<DefaultNode> {
    private final FlowRuleChecker checker;
    private final Function<String, Collection<FlowRule>> ruleProvider = resource -> {
        Map flowRuleMap = FlowRuleManager.getFlowRuleMap();
        return ArmorSlotUtil.getWildcardRules(resource, FlowRuleManager.getFlowRuleKeys(), flowRuleMap);
    };

    public FlowSlot() {
        this(new FlowRuleChecker());
    }

    FlowSlot(FlowRuleChecker checker) {
        AssertUtil.notNull(checker, "flow checker should not be null");
        this.checker = checker;
    }

    @Override
    public void entry(Context context, ResourceWrapper resourceWrapper, DefaultNode node, int count, boolean prioritized, Object ... args) throws Throwable {
        this.checkFlow(resourceWrapper, context, node, count, prioritized);
        this.fireEntry(context, resourceWrapper, node, count, prioritized, args);
    }

    void checkFlow(ResourceWrapper resource, Context context, DefaultNode node, int count, boolean prioritized) throws BlockException {
        this.checker.checkFlow(this.ruleProvider, resource, context, node, count, prioritized);
    }

    @Override
    public void exit(Context context, ResourceWrapper resourceWrapper, int count, Object ... args) {
        this.fireExit(context, resourceWrapper, count, args);
    }
}

