/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.slots.clusterbuilder;

import java.util.HashMap;
import java.util.Map;
import kd.bos.armor.core.EntryType;
import kd.bos.armor.core.context.Context;
import kd.bos.armor.core.node.ClusterNode;
import kd.bos.armor.core.node.DefaultNode;
import kd.bos.armor.core.slotchain.AbstractLinkedProcessorSlot;
import kd.bos.armor.core.slotchain.ResourceWrapper;
import kd.bos.armor.core.slotchain.StringResourceWrapper;
import kd.bos.armor.core.spi.SpiOrder;

@SpiOrder(value=-9000)
public class ClusterBuilderSlot
extends AbstractLinkedProcessorSlot<DefaultNode> {
    private static final Object lock = new Object();
    private static volatile Map<ResourceWrapper, ClusterNode> clusterNodeMap = new HashMap<ResourceWrapper, ClusterNode>();
    private volatile ClusterNode clusterNode = null;

    public static ClusterNode getClusterNode(String id, EntryType type) {
        return clusterNodeMap.get(new StringResourceWrapper(id, type));
    }

    public static ClusterNode getClusterNode(String id) {
        EntryType nodeType;
        if (id == null) {
            return null;
        }
        ClusterNode clusterNode = null;
        EntryType[] entryTypeArray = EntryType.values();
        int n = entryTypeArray.length;
        for (int i = 0; i < n && (clusterNode = clusterNodeMap.get(new StringResourceWrapper(id, nodeType = entryTypeArray[i]))) == null; ++i) {
        }
        return clusterNode;
    }

    public static Map<ResourceWrapper, ClusterNode> getClusterNodeMap() {
        return clusterNodeMap;
    }

    public static void resetClusterNodes(int sampleCount, int interval) {
        for (ClusterNode node : clusterNodeMap.values()) {
            node.reset(sampleCount, interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void entry(Context context, ResourceWrapper resourceWrapper, DefaultNode node, int count, boolean prioritized, Object ... args) throws Throwable {
        if (this.clusterNode == null) {
            Object object = lock;
            synchronized (object) {
                if (this.clusterNode == null) {
                    this.clusterNode = new ClusterNode(context.getTenantId(), resourceWrapper.getName(), resourceWrapper.getResourceType());
                    HashMap<ResourceWrapper, ClusterNode> newMap = new HashMap<ResourceWrapper, ClusterNode>(Math.max(clusterNodeMap.size(), 16));
                    newMap.putAll(clusterNodeMap);
                    newMap.put(node.getId(), this.clusterNode);
                    clusterNodeMap = newMap;
                }
            }
        }
        node.setClusterNode(this.clusterNode);
        this.fireEntry(context, resourceWrapper, node, count, prioritized, args);
    }

    @Override
    public void exit(Context context, ResourceWrapper resourceWrapper, int count, Object ... args) {
        this.fireExit(context, resourceWrapper, count, args);
    }
}

