/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.slots.statistic;

import java.util.Collection;
import kd.bos.armor.core.context.Context;
import kd.bos.armor.core.node.DefaultNode;
import kd.bos.armor.core.node.Node;
import kd.bos.armor.core.slotchain.AbstractLinkedProcessorSlot;
import kd.bos.armor.core.slotchain.ProcessorSlotEntryCallback;
import kd.bos.armor.core.slotchain.ProcessorSlotExitCallback;
import kd.bos.armor.core.slotchain.ResourceWrapper;
import kd.bos.armor.core.slots.block.BlockException;
import kd.bos.armor.core.slots.block.flow.PriorityWaitException;
import kd.bos.armor.core.slots.statistic.StatisticSlotCallbackRegistry;
import kd.bos.armor.core.spi.SpiOrder;
import kd.bos.armor.core.util.TimeUtil;

@SpiOrder(value=-7000)
public class StatisticSlot
extends AbstractLinkedProcessorSlot<DefaultNode> {
    @Override
    public void entry(Context context, ResourceWrapper resourceWrapper, DefaultNode node, int count, boolean prioritized, Object ... args) throws Throwable {
        try {
            this.fireEntry(context, resourceWrapper, node, count, prioritized, args);
            node.increaseThreadNum();
            node.addPassRequest(count);
            if (context.getCurEntry().getOriginNode() != null) {
                context.getCurEntry().getOriginNode().increaseThreadNum();
                context.getCurEntry().getOriginNode().addPassRequest(count);
            }
            for (ProcessorSlotEntryCallback<DefaultNode> handler : StatisticSlotCallbackRegistry.getEntryCallbacks()) {
                handler.onPass(context, resourceWrapper, node, count, args);
            }
        }
        catch (PriorityWaitException ex) {
            node.increaseThreadNum();
            if (context.getCurEntry().getOriginNode() != null) {
                context.getCurEntry().getOriginNode().increaseThreadNum();
            }
            for (ProcessorSlotEntryCallback<DefaultNode> handler : StatisticSlotCallbackRegistry.getEntryCallbacks()) {
                handler.onPass(context, resourceWrapper, node, count, args);
            }
        }
        catch (BlockException e) {
            context.getCurEntry().setBlockError(e);
            node.increaseBlockQps(count);
            if (context.getCurEntry().getOriginNode() != null) {
                context.getCurEntry().getOriginNode().increaseBlockQps(count);
            }
            for (ProcessorSlotEntryCallback<DefaultNode> handler : StatisticSlotCallbackRegistry.getEntryCallbacks()) {
                handler.onBlocked(e, context, resourceWrapper, node, count, args);
            }
            throw e;
        }
        catch (Throwable e) {
            context.getCurEntry().setError(e);
            throw e;
        }
    }

    @Override
    public void exit(Context context, ResourceWrapper resourceWrapper, int count, Object ... args) {
        Node node = context.getCurNode();
        if (context.getCurEntry().getBlockError() == null) {
            long completeStatTime = TimeUtil.currentTimeMillis();
            context.getCurEntry().setCompleteTimestamp(completeStatTime);
            long rt = completeStatTime - context.getCurEntry().getCreateTimestamp();
            Throwable error = context.getCurEntry().getError();
            this.recordCompleteFor(node, count, rt, error);
            this.recordCompleteFor(context.getCurEntry().getOriginNode(), count, rt, error);
        }
        Collection<ProcessorSlotExitCallback> exitCallbacks = StatisticSlotCallbackRegistry.getExitCallbacks();
        for (ProcessorSlotExitCallback handler : exitCallbacks) {
            handler.onExit(context, resourceWrapper, count, args);
        }
        this.fireExit(context, resourceWrapper, count, new Object[0]);
    }

    private void recordCompleteFor(Node node, int batchCount, long rt, Throwable error) {
        if (node == null) {
            return;
        }
        node.addRtAndSuccess(rt, batchCount);
        node.decreaseThreadNum();
        if (error != null && !(error instanceof BlockException)) {
            node.increaseExceptionQps(batchCount);
        }
    }
}

