/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.slots.statistic.metric.occupy;

import java.util.List;
import kd.bos.armor.core.slots.statistic.MetricEvent;
import kd.bos.armor.core.slots.statistic.base.LeapArray;
import kd.bos.armor.core.slots.statistic.base.WindowWrap;
import kd.bos.armor.core.slots.statistic.data.MetricBucket;
import kd.bos.armor.core.slots.statistic.metric.occupy.FutureBucketLeapArray;

public class OccupiableBucketLeapArray
extends LeapArray<MetricBucket> {
    private FutureBucketLeapArray borrowArray;

    public OccupiableBucketLeapArray(int sampleCount, int intervalInMs) {
        super(sampleCount, intervalInMs);
        this.borrowArray = new FutureBucketLeapArray(sampleCount, intervalInMs);
    }

    @Override
    public MetricBucket newEmptyBucket(long time) {
        MetricBucket newBucket = new MetricBucket();
        MetricBucket borrowBucket = (MetricBucket)this.borrowArray.getWindowValue(time);
        if (borrowBucket != null) {
            newBucket.reset(borrowBucket);
        }
        return newBucket;
    }

    @Override
    protected WindowWrap<MetricBucket> resetWindowTo(WindowWrap<MetricBucket> w, long time) {
        w.resetTo(time);
        MetricBucket borrowBucket = (MetricBucket)this.borrowArray.getWindowValue(time);
        if (borrowBucket != null) {
            w.value().reset();
            w.value().addPass((int)borrowBucket.pass());
        } else {
            w.value().reset();
        }
        return w;
    }

    @Override
    public long currentWaiting() {
        this.borrowArray.currentWindow();
        long currentWaiting = 0L;
        List list = this.borrowArray.values();
        for (MetricBucket window : list) {
            currentWaiting += window.pass();
        }
        return currentWaiting;
    }

    @Override
    public void addWaiting(long time, int acquireCount) {
        WindowWrap window = this.borrowArray.currentWindow(time);
        ((MetricBucket)window.value()).add(MetricEvent.PASS, acquireCount);
    }

    @Override
    public void debug(long time) {
        StringBuilder sb = new StringBuilder();
        List lists = this.listAll();
        sb.append("a_Thread_").append(Thread.currentThread().getId()).append(" time=").append(time).append("; ");
        for (WindowWrap window : lists) {
            sb.append(window.windowStart()).append(":").append(((MetricBucket)window.value()).toString()).append(";");
        }
        sb.append("\n");
        lists = this.borrowArray.listAll();
        sb.append("b_Thread_").append(Thread.currentThread().getId()).append(" time=").append(time).append("; ");
        for (WindowWrap window : lists) {
            sb.append(window.windowStart()).append(":").append(((MetricBucket)window.value()).toString()).append(";");
        }
        System.out.println(sb.toString());
    }
}

