/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.armor.core.log.RecordLog;
import kd.bos.armor.core.spi.ServiceLoaderUtil;
import kd.bos.armor.core.spi.SpiOrder;
import kd.bos.armor.core.util.AssertUtil;

public final class SpiLoader {
    private static final Map<String, ServiceLoader> SERVICE_LOADER_MAP = new ConcurrentHashMap<String, ServiceLoader>();

    private SpiLoader() {
    }

    public static <T> T loadFirstInstance(Class<T> clazz) {
        AssertUtil.notNull(clazz, "SPI class cannot be null");
        try {
            Iterator iterator;
            String key = clazz.getName();
            ServiceLoader<T> serviceLoader = SERVICE_LOADER_MAP.get(key);
            if (serviceLoader == null) {
                serviceLoader = ServiceLoaderUtil.getServiceLoader(clazz);
                SERVICE_LOADER_MAP.put(key, serviceLoader);
            }
            if ((iterator = serviceLoader.iterator()).hasNext()) {
                return (T)iterator.next();
            }
            return null;
        }
        catch (Exception t) {
            RecordLog.error("[SpiLoader] ERROR: loadFirstInstance failed", t);
            return null;
        }
    }

    public static <T> T loadFirstInstanceOrDefault(Class<T> clazz, Class<? extends T> defaultClass) {
        AssertUtil.notNull(clazz, "SPI class cannot be null");
        AssertUtil.notNull(defaultClass, "default SPI class cannot be null");
        try {
            String key = clazz.getName();
            ServiceLoader serviceLoader = SERVICE_LOADER_MAP.get(key);
            if (serviceLoader == null) {
                serviceLoader = ServiceLoaderUtil.getServiceLoader(clazz);
                SERVICE_LOADER_MAP.put(key, serviceLoader);
            }
            for (Object instance : serviceLoader) {
                if (instance.getClass() == defaultClass) continue;
                return (T)instance;
            }
            return defaultClass.newInstance();
        }
        catch (Exception t) {
            RecordLog.error("[SpiLoader] ERROR: loadFirstInstanceOrDefault failed", t);
            return null;
        }
    }

    public static <T> T loadHighestPriorityInstance(Class<T> clazz) {
        try {
            String key = clazz.getName();
            ServiceLoader<T> serviceLoader = SERVICE_LOADER_MAP.get(key);
            if (serviceLoader == null) {
                serviceLoader = ServiceLoaderUtil.getServiceLoader(clazz);
                SERVICE_LOADER_MAP.put(key, serviceLoader);
            }
            SpiOrderWrapper<T> w = null;
            for (T spi : serviceLoader) {
                int order = SpiOrderResolver.resolveOrder(spi);
                RecordLog.info("[SpiLoader] Found {} SPI: {} with order {}", clazz.getSimpleName(), spi.getClass().getCanonicalName(), order);
                if (w != null && order >= ((SpiOrderWrapper)w).order) continue;
                w = new SpiOrderWrapper<T>(order, spi);
            }
            return (T)(w == null ? null : ((SpiOrderWrapper)w).spi);
        }
        catch (Exception t) {
            RecordLog.error("[SpiLoader] ERROR: loadHighestPriorityInstance failed", t);
            return null;
        }
    }

    public static <T> List<T> loadInstanceList(Class<T> clazz) {
        try {
            String key = clazz.getName();
            ServiceLoader<T> serviceLoader = SERVICE_LOADER_MAP.get(key);
            if (serviceLoader == null) {
                serviceLoader = ServiceLoaderUtil.getServiceLoader(clazz);
                SERVICE_LOADER_MAP.put(key, serviceLoader);
            }
            ArrayList<T> list = new ArrayList<T>();
            for (T spi : serviceLoader) {
                RecordLog.info("[SpiLoader] Found {} SPI: {}", clazz.getSimpleName(), spi.getClass().getCanonicalName());
                list.add(spi);
            }
            return list;
        }
        catch (Exception t) {
            RecordLog.error("[SpiLoader] ERROR: loadInstanceList failed", t);
            return new ArrayList();
        }
    }

    public static <T> List<T> loadInstanceListSorted(Class<T> clazz) {
        try {
            String key = clazz.getName();
            ServiceLoader<T> serviceLoader = SERVICE_LOADER_MAP.get(key);
            if (serviceLoader == null) {
                serviceLoader = ServiceLoaderUtil.getServiceLoader(clazz);
                SERVICE_LOADER_MAP.put(key, serviceLoader);
            }
            ArrayList orderWrappers = new ArrayList();
            for (T spi : serviceLoader) {
                int order = SpiOrderResolver.resolveOrder(spi);
                SpiOrderResolver.insertSorted(orderWrappers, spi, order);
                RecordLog.info("[SpiLoader] Found {} SPI: {} with order {}", clazz.getSimpleName(), spi.getClass().getCanonicalName(), order);
            }
            ArrayList<Object> list = new ArrayList<Object>(orderWrappers.size());
            for (int i = 0; i < orderWrappers.size(); ++i) {
                list.add(((SpiOrderWrapper)orderWrappers.get(i)).spi);
            }
            return list;
        }
        catch (Exception t) {
            RecordLog.error("[SpiLoader] ERROR: loadInstanceListSorted failed", t);
            return new ArrayList();
        }
    }

    public static <T> List<T> loadPrototypeInstanceListSorted(Class<T> clazz) {
        try {
            ServiceLoader<T> serviceLoader = ServiceLoaderUtil.getServiceLoader(clazz);
            ArrayList orderWrappers = new ArrayList();
            for (T spi : serviceLoader) {
                int order = SpiOrderResolver.resolveOrder(spi);
                SpiOrderResolver.insertSorted(orderWrappers, spi, order);
                RecordLog.debug("[SpiLoader] Found {} SPI: {} with order {}", clazz.getSimpleName(), spi.getClass().getCanonicalName(), order);
            }
            ArrayList<Object> list = new ArrayList<Object>(orderWrappers.size());
            for (int i = 0; i < orderWrappers.size(); ++i) {
                list.add(((SpiOrderWrapper)orderWrappers.get(i)).spi);
            }
            return list;
        }
        catch (Exception t) {
            RecordLog.error("[SpiLoader] ERROR: loadPrototypeInstanceListSorted failed", t);
            return new ArrayList();
        }
    }

    private static class SpiOrderWrapper<T> {
        private final int order;
        private final T spi;

        SpiOrderWrapper(int order, T spi) {
            this.order = order;
            this.spi = spi;
        }

        int getOrder() {
            return this.order;
        }

        T getSpi() {
            return this.spi;
        }
    }

    private static class SpiOrderResolver {
        private SpiOrderResolver() {
        }

        private static <T> void insertSorted(List<SpiOrderWrapper<T>> list, T spi, int order) {
            int idx;
            for (idx = 0; idx < list.size() && list.get(idx).getOrder() <= order; ++idx) {
            }
            list.add(idx, new SpiOrderWrapper<T>(order, spi));
        }

        private static <T> int resolveOrder(T spi) {
            if (!spi.getClass().isAnnotationPresent(SpiOrder.class)) {
                return Integer.MAX_VALUE;
            }
            return spi.getClass().getAnnotation(SpiOrder.class).value();
        }
    }
}

