/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.transport.command.vo;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.armor.core.node.ClusterNode;
import kd.bos.armor.core.node.DefaultNode;
import kd.bos.armor.core.node.metric.MetricNode;
import kd.bos.armor.core.slotchain.ResourceWrapper;
import kd.bos.govern.GovernPoJo;
import kd.bos.instance.Instance;
import kd.bos.util.NetAddressUtils;

public class NodeVo
extends GovernPoJo {
    private static final String APP_NAME = Instance.getAppName();
    private static final String INSTANCE_ID = Instance.getInstanceId();
    private static final String LOCAL_IP = NetAddressUtils.getLocalIpAddress();
    private String tenantId;
    private String appName = APP_NAME;
    private String instanceId = INSTANCE_ID;
    private String ip = LOCAL_IP;
    private String id;
    private String parentId;
    private String resource;
    private Integer threadNum;
    private Long passQps;
    private Long blockQps;
    private Long totalQps;
    private Long averageRt;
    private Long successQps;
    private Long exceptionQps;
    private Long oneMinutePass;
    private Long oneMinuteBlock;
    private Long oneMinuteException;
    private Long oneMinuteTotal;
    private long totalRt;
    private Long timestamp;

    public static NodeVo fromDefaultNode(DefaultNode node, String parentId) {
        if (node == null) {
            return null;
        }
        NodeVo vo = new NodeVo();
        vo.id = UUID.randomUUID().toString();
        vo.parentId = parentId;
        vo.resource = node.getId().getShowName();
        vo.threadNum = node.curThreadNum();
        vo.passQps = (long)node.passQps();
        vo.blockQps = (long)node.blockQps();
        vo.totalQps = (long)node.totalQps();
        vo.averageRt = (long)node.avgRt();
        vo.successQps = (long)node.successQps();
        vo.exceptionQps = (long)node.exceptionQps();
        vo.oneMinuteException = node.totalException();
        vo.oneMinutePass = node.totalRequest() - node.blockRequest();
        vo.oneMinuteBlock = node.blockRequest();
        vo.oneMinuteTotal = node.totalRequest();
        vo.timestamp = System.currentTimeMillis();
        return vo;
    }

    public static NodeVo fromClusterNode(ResourceWrapper name, ClusterNode node) {
        return NodeVo.fromClusterNode(name.getShowName(), node);
    }

    public static NodeVo fromClusterNode(String name, ClusterNode node) {
        if (node == null) {
            return null;
        }
        NodeVo vo = new NodeVo();
        vo.resource = name;
        vo.threadNum = node.curThreadNum();
        vo.passQps = (long)node.passQps();
        vo.blockQps = (long)node.blockQps();
        vo.totalQps = (long)node.totalQps();
        vo.averageRt = (long)node.avgRt();
        vo.successQps = (long)node.successQps();
        vo.exceptionQps = (long)node.exceptionQps();
        vo.oneMinuteException = node.totalException();
        vo.oneMinutePass = node.totalRequest() - node.blockRequest();
        vo.oneMinuteBlock = node.blockRequest();
        vo.oneMinuteTotal = node.totalRequest();
        vo.timestamp = System.currentTimeMillis();
        return vo;
    }

    public static NodeVo fromMetricNode(MetricNode node) {
        if (node == null) {
            return null;
        }
        NodeVo vo = new NodeVo();
        vo.tenantId = node.getTenantId();
        vo.resource = node.getResource();
        vo.threadNum = node.getConcurrency();
        vo.passQps = node.getPassQps();
        vo.blockQps = node.getBlockQps();
        vo.totalQps = vo.passQps + vo.blockQps;
        vo.averageRt = node.getRt();
        vo.successQps = node.getSuccessQps();
        vo.exceptionQps = node.getExceptionQps();
        vo.timestamp = node.getTimestamp();
        vo.totalRt = node.getTotalRt();
        return vo;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public long getTotalRt() {
        return this.totalRt;
    }

    public void setTotalRt(long totalRt) {
        this.totalRt = totalRt;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public Integer getThreadNum() {
        return this.threadNum;
    }

    public void setThreadNum(Integer threadNum) {
        this.threadNum = threadNum;
    }

    public Long getPassQps() {
        return this.passQps;
    }

    public void setPassQps(Long passQps) {
        this.passQps = passQps;
    }

    public Long getBlockQps() {
        return this.blockQps;
    }

    public void setBlockQps(Long blockQps) {
        this.blockQps = blockQps;
    }

    public Long getTotalQps() {
        return this.totalQps;
    }

    public void setTotalQps(Long totalQps) {
        this.totalQps = totalQps;
    }

    public Long getAverageRt() {
        return this.averageRt;
    }

    public void setAverageRt(Long averageRt) {
        this.averageRt = averageRt;
    }

    public Long getSuccessQps() {
        return this.successQps;
    }

    public void setSuccessQps(Long successQps) {
        this.successQps = successQps;
    }

    public Long getExceptionQps() {
        return this.exceptionQps;
    }

    public void setExceptionQps(Long exceptionQps) {
        this.exceptionQps = exceptionQps;
    }

    public Long getOneMinuteException() {
        return this.oneMinuteException;
    }

    public void setOneMinuteException(Long oneMinuteException) {
        this.oneMinuteException = oneMinuteException;
    }

    public Long getOneMinutePass() {
        return this.oneMinutePass;
    }

    public void setOneMinutePass(Long oneMinutePass) {
        this.oneMinutePass = oneMinutePass;
    }

    public Long getOneMinuteBlock() {
        return this.oneMinuteBlock;
    }

    public void setOneMinuteBlock(Long oneMinuteBlock) {
        this.oneMinuteBlock = oneMinuteBlock;
    }

    public Long getOneMinuteTotal() {
        return this.oneMinuteTotal;
    }

    public void setOneMinuteTotal(Long oneMinuteTotal) {
        this.oneMinuteTotal = oneMinuteTotal;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Map<String, Object> data2map() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appName", this.appName);
        map.put("instanceId", this.instanceId);
        map.put("ip", this.ip);
        map.put("id", this.id);
        map.put("parentId", this.parentId);
        map.put("resource", this.resource);
        map.put("tenantId", this.tenantId);
        map.put("threadNum", this.threadNum);
        map.put("passQps", this.passQps);
        map.put("blockQps", this.blockQps);
        map.put("totalQps", this.totalQps);
        map.put("averageRt", this.averageRt);
        map.put("successQps", this.successQps);
        map.put("exceptionQps", this.exceptionQps);
        map.put("oneMinutePass", this.oneMinutePass);
        map.put("oneMinuteBlock", this.oneMinuteBlock);
        map.put("oneMinuteException", this.oneMinuteException);
        map.put("oneMinuteTotal", this.oneMinuteTotal);
        map.put("timestamp", this.timestamp);
        map.put("totalRt", this.totalRt);
        return map;
    }
}

