/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kafka.sender;

import java.util.Properties;
import kd.bos.kafka.IKafkaSender;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.log4j.Logger;

public class AbstractKafkaSender<T>
implements IKafkaSender<T> {
    private static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    private static final String SASL_JAAS_CONFIG = "sasl.jaas.config";
    private static final String SASL_MECHANISM = "sasl.mechanism";
    private static final String SECURITY_PROTOCOL = "security.protocol";
    private static final String DEFAULT_SECURITY_PROTOCOL = "SASL_PLAINTEXT";
    private static final String DEFAULT_SASL_MECHANISM = "PLAIN";
    private static Logger logger = Logger.getLogger(AbstractKafkaSender.class);
    private String topic;
    private Properties props;
    private Producer<String, T> producer;

    public AbstractKafkaSender(String serializerType, String host, String topic, String user, String pwd) {
        this.topic = topic;
        this.props = this.getProducerProperties(serializerType, host, user, pwd);
        this.producer = new KafkaProducer(this.props);
    }

    private static String getKafkaAuthConfig(String userName, String password) {
        return "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"" + userName + "\" password=\"" + password + "\";";
    }

    @Override
    public void send(T kafkaMsg) {
        try {
            this.producer.send(new ProducerRecord(this.topic, kafkaMsg));
        }
        catch (Exception e) {
            logger.warn((Object)"AbstractKafkaSender send error", (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.producer.close();
    }

    private Properties getProducerProperties(String serializerType, String host, String user, String password) {
        Properties properties = new Properties();
        properties.setProperty(BOOTSTRAP_SERVERS_CONFIG, host);
        properties.setProperty("key.serializer", serializerType);
        properties.setProperty("value.serializer", serializerType);
        properties.setProperty("acks", "0");
        properties.setProperty("max.request.size", String.valueOf(0xA00000));
        if (user != null && password != null) {
            String config = AbstractKafkaSender.getKafkaAuthConfig(user, password);
            properties.setProperty(SASL_JAAS_CONFIG, config);
            properties.setProperty(SASL_MECHANISM, DEFAULT_SASL_MECHANISM);
            properties.setProperty(SECURITY_PROTOCOL, DEFAULT_SECURITY_PROTOCOL);
        }
        return properties;
    }
}

