/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.httpsse.core;

import java.net.URI;
import java.net.URISyntaxException;
import kd.bos.httpsse.core.SSEConfig;
import kd.bos.httpsse.core.SSEServiceInfo;
import kd.bos.httpsse.core.StringUtils;

public class MServiceNode {
    private String host;
    private String port;
    private String appName;

    public MServiceNode(String host, String appName, String webPort) {
        this.host = host;
        this.appName = appName;
        this.port = webPort;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getSSEServiceUri(SSEServiceInfo svc) {
        String myHost = this.host;
        if (SSEConfig.current().getSSEDevEnv()) {
            myHost = "localhost";
        }
        String ctxUrl = SSEConfig.current().getContextUrl();
        try {
            String tenant = new URI(ctxUrl).getPath();
            if (StringUtils.isEmpty(tenant)) {
                tenant = "/";
            }
            String sseServletPrefix = SSEConfig.current().getSSEServletPrefix();
            return String.format("http://%s:%s%s/%s/%s/%s", myHost, this.port, tenant, sseServletPrefix, svc.getAppId(), svc.getServiceClass());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

