/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.httpsse.core;

import java.util.HashMap;
import java.util.Map;

public class SSEConfig {
    private static final SSEConfig _current = new SSEConfig();
    private static final int systemcorecount = Runtime.getRuntime().availableProcessors();

    private SSEConfig() {
    }

    public static SSEConfig current() {
        return _current;
    }

    public boolean getSSEDevEnv() {
        return this.getBoolConfigItem("bos.sse.dev.env", false);
    }

    public String getContextUrl() {
        return System.getProperty("domain.contextUrl", "http://localhost:8080/ierp");
    }

    public String getSSEServletPrefix() {
        return System.getProperty("bos.sse.servletprefix", "sse");
    }

    public boolean getSSEServerAsync() {
        return this.getBoolConfigItem("bos.sse.server.async", false);
    }

    public int getAsyncContextTimeout() {
        return this.getIntConfigItem("bos.web.http.asynccontexttimeout", 300000);
    }

    public Map<String, String> getSSEServerResponseOtherHeaders() {
        HashMap<String, String> ret = new HashMap<String, String>();
        String headers = System.getProperty("bos.sse.server.otherheaders", "Cache-Control:no-cache;X-Accel-Buffering:no");
        for (String header : headers.split(";")) {
            String[] name_value = header.split(":");
            if (name_value.length != 2) continue;
            ret.put(name_value[0], name_value[1]);
        }
        return ret;
    }

    @Deprecated
    public String getSSEServerMode() {
        return System.getProperty("bos.sse.server.mode", "normal");
    }

    public int getSSERxProducerCoreThreads() {
        return this.getIntConfigItem("bos.sse.rx.corethreads", 1);
    }

    public int getSSERxProducerMaxThreads() {
        return this.getIntConfigItem("bos.sse.rx.maxthreads", systemcorecount * 2);
    }

    public boolean getSingletonService() {
        return this.getBoolConfigItem("bos.sse.server.singeltonservice", true);
    }

    public String getEventErrorFormat() {
        return System.getProperty("bos.sse.server.errorformat", "error:%s" + System.lineSeparator() + System.lineSeparator());
    }

    public String getEventMessageFormat() {
        return System.getProperty("bos.sse.server.messageformat", "data:%s" + System.lineSeparator() + System.lineSeparator());
    }

    public int getSSEClientMaxTotal() {
        return this.getIntConfigItem("bos.sse.client.maxtotal", 100);
    }

    public int getSSEClientDefaultMaxPerRoute() {
        return this.getIntConfigItem("bos.sse.client.defaultmaxperroute", 20);
    }

    public int getSSERouterMaxTotal() {
        return this.getIntConfigItem("bos.sse.router.maxtotal", 100);
    }

    public int getSSERouterDefaultMaxPerRoute() {
        return this.getIntConfigItem("bos.sse.router.defaultmaxperroute", 20);
    }

    private int getIntConfigItem(String key, int defaultValue) {
        String v = System.getProperty(key, String.valueOf(defaultValue));
        return Integer.parseInt(v);
    }

    private boolean getBoolConfigItem(String key, boolean defaultValue) {
        String v = System.getProperty(key, String.valueOf(defaultValue));
        return Boolean.parseBoolean(v);
    }
}

