/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.httpsse.server;

import java.security.SecureRandom;
import java.util.List;
import kd.bos.httpsse.core.MServiceNode;
import kd.bos.httpsse.core.StringUtils;
import kd.bos.instance.Instance;
import kd.bos.mservice.appsplit.AppSplitServiceManager;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.mservice.monitor.ServiceInfoManger;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterHealth;
import org.apache.commons.lang.ArrayUtils;

public class HealthServiceUtils {
    private static final SecureRandom random = new SecureRandom();

    public static boolean isStandaloneWebNode() {
        return Instance.isStandaloneWebNode();
    }

    public static boolean isWebMserviceInOne() {
        return Instance.isWebMserviceInOne();
    }

    public static boolean isDeployApp(String appId) {
        if (!Instance.isAppSplit()) {
            return !Instance.isStandaloneWebNode();
        }
        return ArrayUtils.contains((Object[])Instance.getAppIds(), (Object)appId);
    }

    public static MServiceNode getHealthMServiceNode(String appId) {
        if (StringUtils.isEmpty(appId)) {
            throw new IllegalArgumentException("appid is null");
        }
        String appName = null;
        if (Instance.isAppSplit() && (appName = AppSplitServiceManager.getAppSplitService((String)appId, null)) == null) {
            throw new RuntimeException("the app " + appId + " is not deployment");
        }
        List serviceInfoList = ServiceInfoManger.getInstance().getServiceList();
        double leastLoad = -2.0;
        int leastCount = 0;
        int[] leastIndices = new int[serviceInfoList.size()];
        for (int i = 0; i < serviceInfoList.size(); ++i) {
            ServiceInfo serviceInfo = (ServiceInfo)serviceInfoList.get(i);
            if (appName != null && !appName.equals(serviceInfo.getAppName())) continue;
            double activeLoad = ClusterHealth.getHealth((String)serviceInfo.getInstanceId());
            if (leastLoad == -2.0 || activeLoad < leastLoad) {
                leastLoad = activeLoad;
                leastCount = 1;
                leastIndices[0] = i;
                continue;
            }
            if (activeLoad != leastLoad) continue;
            leastIndices[leastCount++] = i;
        }
        ServiceInfo choose = leastCount == 0 ? null : (leastCount == 1 ? (ServiceInfo)serviceInfoList.get(leastIndices[0]) : (ServiceInfo)serviceInfoList.get(leastIndices[random.nextInt(leastCount)]));
        if (choose == null) {
            throw new RuntimeException("can't find health instance to route");
        }
        return new MServiceNode(choose.getIp(), choose.getAppName(), choose.getWebPort());
    }
}

