/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.httpsse.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.httpsse.core.SSEServiceInfo;
import kd.bos.httpsse.core.StringUtils;
import org.apache.http.client.methods.HttpUriRequest;
import org.eclipse.jetty.util.StringUtil;

public class HttpUtils {
    public static void setRequestHeaders(HttpUriRequest request) {
        request.addHeader("Accept", "text/event-stream");
        request.addHeader("Cache-Control", "no-cache");
        request.addHeader("Connection", "keep-alive");
        request.addHeader("Content-Type", "application/json");
        request.addHeader("charset", "utf-8");
    }

    public static String getQueryString(HttpServletRequest request, String key, String defaultValue) {
        Map map = request.getParameterMap();
        if (map.containsKey(key)) {
            return ((String[])map.get(key))[0];
        }
        return defaultValue;
    }

    public static String getRequestBody(HttpServletRequest request) {
        try {
            StringBuilder sb = new StringBuilder();
            request.getReader().lines().forEach(sb::append);
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static SSEServiceInfo getService(HttpServletRequest request) {
        String[] items = request.getRequestURI().split("/");
        if (items.length > 1) {
            String svcName = items[items.length - 1].trim();
            String appId = items[items.length - 2].trim();
            return new SSEServiceInfo(appId, svcName);
        }
        throw new IllegalArgumentException("URL illegal, no suitable service name or appId found");
    }

    public static void setResponseHeaders(HttpServletResponse response, Map<String, String> otherHeaders) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/event-stream");
        response.setHeader("Connection", "keep-alive");
        for (Map.Entry<String, String> entry : otherHeaders.entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
    }

    public static void outputOnce(ServletOutputStream outputStream, String msg, String format) throws IOException {
        if (StringUtil.isNotBlank((String)format)) {
            msg = String.format(format, msg);
        }
        outputStream.write(StringUtils.toBytes(msg));
        outputStream.flush();
    }

    public static String readRequest(HttpServletRequest request) throws IOException {
        return HttpUtils.readReader(request.getReader());
    }

    public static String readReader(BufferedReader reader) throws IOException {
        String line;
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
        }
        return stringBuilder.toString();
    }
}

