/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.httpsse.server;

import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.httpsse.server.HttpUtils;
import kd.bos.httpsse.server.SSEServletBehavior;
import kd.bos.httpsse.server.ServletHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SSEServiceExecute
extends SSEServletBehavior {
    private final Log log = LogFactory.getLog(SSEServiceExecute.class);

    public SSEServiceExecute(HttpServlet servlet) {
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String json = HttpUtils.getQueryString(request, "args", "[]");
        this.callHandler(json, request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        String json = HttpUtils.getRequestBody(request);
        this.callHandler(json, request, response);
    }

    private void callHandler(String json, HttpServletRequest request, HttpServletResponse response) {
        try {
            String serviceName = HttpUtils.getService(request).getServiceClass();
            ServletHandler handler = ServletHandler.getImpl(serviceName);
            handler.callSSEService(serviceName, json, request, response);
        }
        catch (Exception ex) {
            response.setStatus(500);
            try {
                response.getOutputStream().println(ex.getMessage());
            }
            catch (IOException e) {
                this.log.error((Throwable)e);
            }
        }
    }
}

