/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.httpsse.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.httpsse.core.MServiceNode;
import kd.bos.httpsse.core.SSEServiceInfo;
import kd.bos.httpsse.core.StringUtils;
import kd.bos.httpsse.server.HealthServiceUtils;
import kd.bos.httpsse.server.HttpUtils;
import kd.bos.httpsse.server.SSEServletBehavior;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class SSEServiceRoute
extends SSEServletBehavior {
    private final Log log = LogFactory.getLog(SSEServiceRoute.class);
    private final HttpServlet servlet;

    public SSEServiceRoute(HttpServlet servlet) {
        this.servlet = servlet;
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        new Router(request, response).doGet();
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        new Router(request, response).doPost();
    }

    private static class Router {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final SSEServiceInfo serviceInfo;

        public Router(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
            this.serviceInfo = HttpUtils.getService(request);
        }

        public void doGet() throws IOException {
            this.forwardRequest();
        }

        public void doPost() throws IOException {
            this.forwardRequest();
        }

        public void forwardRequest() throws IOException {
            block42: {
                BasicCookieStore cookieStore = new BasicCookieStore();
                try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultCookieStore((CookieStore)cookieStore).build();){
                    HttpGet forwardRequest;
                    StringEntity entity;
                    String targetUrl = this.getForwardUrl();
                    if (this.request.getMethod().equalsIgnoreCase("POST")) {
                        HttpPost postRequest = new HttpPost(targetUrl);
                        String requestContent = HttpUtils.readRequest(this.request);
                        entity = new StringEntity(requestContent);
                        postRequest.setEntity((HttpEntity)entity);
                        forwardRequest = postRequest;
                    } else {
                        forwardRequest = new HttpGet(targetUrl);
                    }
                    HttpUtils.setRequestHeaders((HttpUriRequest)forwardRequest);
                    if (this.request.getCookies() != null) {
                        StringBuilder cookieHeader = new StringBuilder();
                        for (Cookie cookie : this.request.getCookies()) {
                            if (cookieHeader.length() > 0) {
                                cookieHeader.append("; ");
                            }
                            cookieHeader.append(cookie.getName()).append("=").append(cookie.getValue());
                        }
                        forwardRequest.setHeader("Cookie", cookieHeader.toString());
                    }
                    HttpUtils.setResponseHeaders(this.response, new HashMap<String, String>());
                    CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)forwardRequest);
                    Object object = null;
                    try {
                        this.response.setStatus(resp.getStatusLine().getStatusCode());
                        entity = resp.getEntity();
                        if (entity == null) break block42;
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));){
                            String line;
                            while ((line = reader.readLine()) != null) {
                                this.response.getOutputStream().println(line);
                                this.response.getOutputStream().flush();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (resp != null) {
                            if (object != null) {
                                try {
                                    resp.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                resp.close();
                            }
                        }
                    }
                }
            }
        }

        private String getForwardUrl() {
            MServiceNode node = HealthServiceUtils.getHealthMServiceNode(this.serviceInfo.getAppId());
            String uri = node.getSSEServiceUri(this.serviceInfo);
            String qs = this.request.getQueryString();
            if (!StringUtils.isEmpty(qs)) {
                uri = uri + "?" + qs;
            }
            return uri;
        }
    }
}

