/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.httpsse.server;

import java.io.IOException;
import java.util.Random;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.httpsse.core.SSEConfig;
import kd.bos.httpsse.core.SSEServiceInfo;
import kd.bos.httpsse.server.HealthServiceUtils;
import kd.bos.httpsse.server.HttpUtils;
import kd.bos.httpsse.server.SSEServiceExecute;
import kd.bos.httpsse.server.SSEServiceRoute;
import kd.bos.httpsse.server.SSEServletBehavior;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SSEServlet
extends HttpServlet {
    private final Log log = LogFactory.getLog(SSEServlet.class);
    private static int executedRequestCount = 0;
    private static boolean isRouted = false;

    public void init(ServletConfig cfg) throws ServletException {
        super.init(cfg);
    }

    public SSEServletBehavior getBehaviorImpl(SSEServiceInfo svcInfo) {
        if (SSEConfig.current().getSSEDevEnv()) {
            this.log.info("!!!sse thread id:" + Thread.currentThread().getId());
            this.log.info("!!!sse thread name:" + Thread.currentThread().getName());
            boolean toExecute = new Random().nextBoolean();
            if (toExecute) {
                this.log.info("!!!execute directly!!!,times:" + ++executedRequestCount);
            } else {
                this.log.info("!!!execute by router");
            }
            if (isRouted || toExecute) {
                isRouted = false;
                return new SSEServiceExecute(this);
            }
            isRouted = true;
        } else if (this.executeDirectly(svcInfo.getAppId())) {
            return new SSEServiceExecute(this);
        }
        return new SSEServiceRoute(this);
    }

    private boolean executeDirectly(String appId) {
        boolean isStandaloneWebNode = HealthServiceUtils.isStandaloneWebNode();
        if (!isStandaloneWebNode) {
            return HealthServiceUtils.isDeployApp(appId);
        }
        return false;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SSEServiceInfo svcInfo = HttpUtils.getService(request);
        this.getBehaviorImpl(svcInfo).doGet(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SSEServiceInfo svcInfo = HttpUtils.getService(request);
        this.getBehaviorImpl(svcInfo).doPost(request, response);
    }
}

