/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.httpsse.service.rx;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import kd.bos.httpsse.core.SSEConfig;
import kd.bos.httpsse.server.HttpUtils;
import kd.bos.httpsse.service.rx.SSESubscriber;

public class AsyncHttpSubscriber
implements SSESubscriber<String> {
    private final ServletOutputStream output;
    private final AsyncContext ctx;

    public AsyncHttpSubscriber(AsyncContext ctx) throws IOException {
        this.ctx = ctx;
        this.output = ctx.getResponse().getOutputStream();
    }

    @Override
    public void onNext(String msg) {
        String msgFormat = SSEConfig.current().getEventMessageFormat();
        try {
            HttpUtils.outputOnce(this.output, msg, msgFormat);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onError(Throwable ex) {
        String msgFormat = SSEConfig.current().getEventErrorFormat();
        try {
            HttpUtils.outputOnce(this.output, ex.getMessage(), msgFormat);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.ctx.complete();
        }
    }

    @Override
    public void onComplete() {
        this.ctx.complete();
    }
}

