/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.store.db.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.entity.QueueEntity;

public class QueueEntityHelper {
    public static void initTable(IStoreDbConfig storeDbConfig) {
        String createIndexSql;
        String indexName;
        String[] generalFieldNameArray;
        String routeKey = storeDbConfig.getRouteKey();
        String tableName = storeDbConfig.getQueueTable();
        boolean exists = DB.exitsTable((DBRoute)DBRoute.of((String)routeKey), (String)tableName);
        if (!exists) {
            String pkConstraintName = "PK_" + tableName;
            String createTableCageSwitch = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '" + tableName + "') \nCREATE TABLE " + tableName + " (\nFID         BIGINT NOT NULL,\nFVHOST      VARCHAR(50) NOT NULL DEFAULT ' ',\nFNAME        VARCHAR(255) NOT NULL DEFAULT ' ',\nFREALNAME        VARCHAR(255) NOT NULL DEFAULT ' ',\nFREGION        VARCHAR(50) NOT NULL DEFAULT ' ',\nFAPPID        VARCHAR(50) NOT NULL DEFAULT ' ',\nFSEQUENTIAL CHAR(1) NOT NULL DEFAULT ' ',\nFCREATETIME DATETIME NOT NULL,\nFUPDATETIME DATETIME,\nFCONSUMERCLASS   VARCHAR(255) NOT NULL DEFAULT ' ',\nFCONSUMERCONCURRENCY INT NOT NULL DEFAULT 0\n);";
            DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)createTableCageSwitch);
            String pkIdSql = "EXEC P_ALTERPK '" + pkConstraintName + "', '" + tableName + "', 'FID', '1'";
            DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)pkIdSql);
        }
        for (String tempFieldName : generalFieldNameArray = new String[]{"FREALNAME"}) {
            indexName = "IDX_" + tableName + "_" + tempFieldName;
            createIndexSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '" + indexName + "') CREATE UNIQUE INDEX " + indexName + " ON " + tableName + " ( " + tempFieldName + " );";
            DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)createIndexSql);
        }
        for (String tempFieldName : generalFieldNameArray = new String[]{"FVHOST"}) {
            indexName = "IDX_" + tableName + "_" + tempFieldName;
            createIndexSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '" + indexName + "') CREATE INDEX " + indexName + " ON " + tableName + " ( " + tempFieldName + " );";
            DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)createIndexSql);
        }
    }

    public static boolean insert(IStoreDbConfig storeDbConfig, QueueEntity queueEntity) {
        String queueTable = storeDbConfig.getQueueTable();
        String insertSql = "insert into " + queueTable + " (fid,fvhost,fname,frealname,fregion,fappid,fsequential,fcreatetime,fupdatetime,fconsumerclass,fconsumerconcurrency) values(?,?,?,?,?,?,?,?,?,?,?);";
        ArrayList insertList = new ArrayList();
        Collections.addAll(insertList, queueEntity.getId(), queueEntity.getVhost(), queueEntity.getName(), queueEntity.getRealName(), queueEntity.getRegion(), queueEntity.getAppId(), queueEntity.isSequential(), queueEntity.getCreateTime(), queueEntity.getUpdateTime(), queueEntity.getConsumerClass(), queueEntity.getConsumerConcurrency());
        return DB.execute((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)insertSql, (Object[])insertList.toArray(new Object[0]));
    }

    public static QueueEntity query(IStoreDbConfig storeDbConfig, String queueRealName) {
        String queueTable = storeDbConfig.getQueueTable();
        String selectSql = "select fid,fvhost,fname,frealname,fregion,fappid,fsequential,fcreatetime,fupdatetime,fconsumerclass,fconsumerconcurrency from " + queueTable + " where frealname = ?";
        QueueEntity resultEntity = (QueueEntity)DB.query((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)selectSql, (Object[])new Object[]{queueRealName}, resultSet -> {
            if (resultSet.next()) {
                QueueEntity tempResultEntity = new QueueEntity();
                tempResultEntity.setId(resultSet.getLong("fid"));
                tempResultEntity.setVhost(resultSet.getString("fvhost"));
                tempResultEntity.setName(resultSet.getString("fname"));
                tempResultEntity.setRealName(resultSet.getString("frealname"));
                tempResultEntity.setRegion(resultSet.getString("fregion"));
                tempResultEntity.setAppId(resultSet.getString("fappid"));
                tempResultEntity.setSequential(resultSet.getBoolean("fsequential"));
                tempResultEntity.setCreateTime(resultSet.getTimestamp("fcreatetime"));
                tempResultEntity.setUpdateTime(resultSet.getTimestamp("fupdatetime"));
                tempResultEntity.setConsumerClass(resultSet.getString("fconsumerclass"));
                tempResultEntity.setConsumerConcurrency(resultSet.getInt("fconsumerconcurrency"));
                return tempResultEntity;
            }
            return null;
        });
        return resultEntity;
    }

    public static boolean update(IStoreDbConfig storeDbConfig, QueueEntity queueEntity) {
        String queueTable = storeDbConfig.getQueueTable();
        String updateSql = "update " + queueTable + " set fvhost=?,fname=?,fregion=?,fappid=?,fsequential=?,fconsumerClass=?,fconsumerConcurrency=?,fupdatetime=? where frealname=?";
        ArrayList updateList = new ArrayList();
        Collections.addAll(updateList, queueEntity.getVhost(), queueEntity.getName(), queueEntity.getRegion(), queueEntity.getAppId(), queueEntity.isSequential(), queueEntity.getConsumerClass(), queueEntity.getConsumerConcurrency(), new Date(), queueEntity.getRealName());
        boolean flag = false;
        int updateSize = DB.update((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)updateSql, (Object[])updateList.toArray(new Object[0]));
        if (updateSize > 0) {
            flag = true;
        }
        return flag;
    }

    public static boolean delete(IStoreDbConfig storeDbConfig, String queueName) {
        String msgTable = storeDbConfig.getQueueMessageTable();
        String deleteSql = "delete from " + msgTable + " where fname = ?";
        boolean flag = false;
        int deleteSize = DB.update((DBRoute)DBRoute.of((String)storeDbConfig.getRouteKey()), (String)deleteSql, (Object[])new Object[]{queueName});
        if (deleteSize > 0) {
            flag = true;
        }
        return flag;
    }
}

