/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.store.db.helper;

import java.util.ServiceLoader;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.helper.QueueEntityHelper;
import kd.bos.pigeon.core.store.db.helper.QueueMessageEntityHelper;
import kd.bos.pigeon.core.store.db.helper.QueueTodoMessageEntityHelper;

public class QueueTableHelper {
    private static final Log LOGGER = LogFactory.getLog(QueueTableHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tableInit() {
        String accountId = RequestContext.get().getAccountId();
        DLock dLock = DLock.create((String)("/dlock/pigeon/tableInit_" + accountId));
        try {
            if (!dLock.tryLock()) {
                return;
            }
            Class.forName("kd.bos.ksql.shell.Driver");
            DtsExcludeSyncContext.create();
            for (IStoreDbConfig tempStoreDbConfig : ServiceLoader.load(IStoreDbConfig.class)) {
                TXHandle handle = TX.requiresNew((String)("PIGEON_TABLE_INIT_" + accountId + "_" + tempStoreDbConfig.bizType()));
                Throwable throwable = null;
                try {
                    QueueEntityHelper.initTable(tempStoreDbConfig);
                    QueueMessageEntityHelper.initTable(tempStoreDbConfig);
                    QueueTodoMessageEntityHelper.initTable(tempStoreDbConfig);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (handle == null) continue;
                    if (throwable != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    handle.close();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("pigeonServerTableInitError", (Throwable)e);
        }
        finally {
            dLock.unlock();
        }
    }
}

