/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pigeon.core.support.instance;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import kd.bos.framework.instance.ClusterInstances;
import kd.bos.framework.zoowhisper.NodeChangeListener;
import kd.bos.framework.zoowhisper.ZooEventifyCenter;
import kd.bos.framework.zoowhisper.ZooEventifyCenterFactory;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.pigeon.core.constant.PigeonConstant;
import kd.bos.pigeon.core.support.PigeonRequestContextUtil;
import kd.bos.pigeon.core.support.instance.ServiceEvent;
import kd.bos.pigeon.core.support.instance.ServiceEventManager;
import kd.bos.pigeon.core.support.instance.ServiceInfo;
import kd.bos.service.invoke.endpoint.EndPointInvokeServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CoreConstants;
import kd.bos.util.JSONUtils;
import kd.bos.util.LRUCacheMap;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;

public class ServiceInfoManager {
    private static final Log LOGGER = LogFactory.getLog(ServiceInfoManager.class);
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"PigeonServiceInfoManagerThread-", (int)2);
    private static final ThreadPool serviceInfoChangeThreadPool = ThreadPools.newFixedThreadPool((String)"PigeonServiceInfoChange-", (int)1);
    private static final AtomicReference<Map<String, ServiceInfo>> instanceId2serviceInfoMap = new AtomicReference(new ConcurrentHashMap());
    private static final AtomicReference<Map<String, Set<ServiceInfo>>> appId2serviceInfoSetMap = new AtomicReference(new ConcurrentHashMap());
    private static final LRUCacheMap<String, Boolean> instanceId2ServiceRpcStatus = new LRUCacheMap(500);
    private static final LRUCacheMap<String, Boolean> downInstanceIdCache = new LRUCacheMap(500);
    private static final Map<String, ServiceInfo> backgroundCheckServiceInfoMap = new ConcurrentHashMap<String, ServiceInfo>();
    private static final AtomicInteger backgroundCheckTimes = new AtomicInteger();
    private static final AtomicInteger backgroundCheckCount = new AtomicInteger();
    private static ServiceInfo currServiceInfo;
    private static final AtomicBoolean isServiceObserverInit;
    private static final AtomicInteger onChangeCount;

    public static void initServiceInfoObserver() {
        if (isServiceObserverInit.compareAndSet(false, true)) {
            ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
            messageCenter.addWatch("configUrl", CoreConstants.MONITORROOTPATH, new NodeChangeListener(){

                public void onChange(String key, String value) {
                    boolean down = StringUtils.isEmpty((String)value);
                    LOGGER.info("onChange {} {}", (Object)key, (Object)(down ? "down" : "update"));
                    String instanceId = key.split("\\(")[0];
                    if (down) {
                        downInstanceIdCache.put((Object)instanceId, (Object)true);
                    } else {
                        downInstanceIdCache.remove((Object)instanceId);
                    }
                    int flag = onChangeCount.incrementAndGet();
                    ServiceInfoManager.runInPipe(() -> {
                        if (flag == onChangeCount.get()) {
                            ServiceInfoManager.updateServiceInfo(true);
                        }
                    });
                }
            });
            ServiceInfoManager.syncRunInPipe(ServiceInfoManager::initServiceInfo);
        }
    }

    public static void syncNotifyUpdateServiceInfo(boolean notifyServiceEventEnable) {
        ServiceInfoManager.syncRunInPipe(() -> ServiceInfoManager.updateServiceInfo(notifyServiceEventEnable));
    }

    public static void asyncNotifyUpdateServiceInfo(boolean notifyServiceEventEnable) {
        int flag = onChangeCount.incrementAndGet();
        ServiceInfoManager.runInPipe(() -> {
            if (flag == onChangeCount.get()) {
                ServiceInfoManager.updateServiceInfo(notifyServiceEventEnable);
            }
        });
    }

    private static void runInPipe(Runnable runnable) {
        serviceInfoChangeThreadPool.execute(runnable);
    }

    private static void syncRunInPipe(Runnable runnable) {
        Future future = serviceInfoChangeThreadPool.submit(() -> {
            runnable.run();
            return true;
        });
        try {
            future.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initServiceInfo() {
        LOGGER.info("initServiceInfo start");
        Map<String, ServiceInfo> allOriginServiceInfos = ServiceInfoManager.getAllOriginServiceInfos();
        if (allOriginServiceInfos == null) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getAllOriginServiceInfos,allOriginServiceInfos:{}", allOriginServiceInfos);
        }
        ServiceInfoManager.serviceInfoFirstInit(allOriginServiceInfos);
        ServiceInfoManager.asyncNotifyUpdateServiceInfo(true);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("initServiceInfo,appId2serviceInfoSetMap:{}", appId2serviceInfoSetMap);
        }
        LOGGER.info("initServiceInfo end");
    }

    private static Map<String, ServiceInfo> getAllOriginServiceInfos() {
        Map nodesMap = ClusterInstances.getAllOriginNodesString();
        try {
            ConcurrentHashMap<String, ServiceInfo> innerMap = new ConcurrentHashMap<String, ServiceInfo>();
            for (Map.Entry entry : nodesMap.entrySet()) {
                ServiceInfo tempServiceInfo = (ServiceInfo)JSONUtils.cast((String)((String)entry.getValue()), ServiceInfo.class, (boolean)true);
                if ((PigeonConstant.LOCAL_SERVER_STANDALONE || PigeonConstant.LOCAL_SERVER_CLUSTER) && !NetAddressUtils.getLocalIpAddress().equals(tempServiceInfo.getIp()) || tempServiceInfo.isGateWay() || StringUtils.isEmpty((String)tempServiceInfo.getRpcPort())) continue;
                innerMap.put(tempServiceInfo.getInstanceId(), tempServiceInfo);
                if (!tempServiceInfo.getInstanceId().equals(Instance.getInstanceId())) continue;
                currServiceInfo = tempServiceInfo;
            }
            return innerMap;
        }
        catch (Exception e) {
            LOGGER.error("getAllOriginServiceInfos error", (Throwable)e);
            return null;
        }
    }

    private static void serviceInfoFirstInit(Map<String, ServiceInfo> innerInstanceId2serviceInfoMap) {
        ConcurrentHashMap<String, ServiceInfo> newInstanceId2serviceInfoMap = new ConcurrentHashMap<String, ServiceInfo>();
        ServiceInfoManager.pigeonServiceInfoFirstInit(newInstanceId2serviceInfoMap, innerInstanceId2serviceInfoMap);
        ServiceInfoManager.executionServiceInfoFirstInit(newInstanceId2serviceInfoMap, innerInstanceId2serviceInfoMap);
        ConcurrentHashMap<String, Set> newAppId2serviceInfoSetMap = new ConcurrentHashMap<String, Set>();
        for (Map.Entry entry : newInstanceId2serviceInfoMap.entrySet()) {
            ServiceInfo tempServiceInfo = (ServiceInfo)entry.getValue();
            if (!Instance.isAppSplit()) {
                Set tempServiceInfoSet = newAppId2serviceInfoSetMap.computeIfAbsent("all", key -> new HashSet());
                tempServiceInfoSet.add(tempServiceInfo);
                continue;
            }
            String[] tempAppIdArray = tempServiceInfo.getAppIds();
            if (tempAppIdArray == null || tempAppIdArray.length <= 0) continue;
            for (String tempAppId : tempAppIdArray) {
                Set tempServiceInfoSet = newAppId2serviceInfoSetMap.computeIfAbsent(tempAppId, key -> new HashSet());
                tempServiceInfoSet.add(tempServiceInfo);
            }
        }
        instanceId2serviceInfoMap.set(newInstanceId2serviceInfoMap);
        appId2serviceInfoSetMap.set(newAppId2serviceInfoSetMap);
    }

    private static void pigeonServiceInfoFirstInit(Map<String, ServiceInfo> newInstanceId2serviceInfoMap, Map<String, ServiceInfo> innerInstanceId2serviceInfoMap) {
        ServiceInfo tempServiceInfo;
        int slaveNum = PigeonConstant.ELECTOR_SLAVE_NUMBER_VALUE;
        if (slaveNum < 1) {
            return;
        }
        HashSet<ServiceInfo> pigeonServiceInfoSet = new HashSet<ServiceInfo>(innerInstanceId2serviceInfoMap.size());
        if (Instance.isAppSplit()) {
            for (Map.Entry<String, ServiceInfo> tempEntry : innerInstanceId2serviceInfoMap.entrySet()) {
                tempServiceInfo = tempEntry.getValue();
                if (tempServiceInfo.getAppIds() == null || tempServiceInfo.getAppIds().length <= 0 || !Arrays.asList(tempServiceInfo.getAppIds()).contains("pigeon")) continue;
                pigeonServiceInfoSet.add(tempServiceInfo);
            }
        } else {
            for (Map.Entry<String, ServiceInfo> tempEntry : innerInstanceId2serviceInfoMap.entrySet()) {
                tempServiceInfo = tempEntry.getValue();
                pigeonServiceInfoSet.add(tempServiceInfo);
            }
        }
        if (pigeonServiceInfoSet.size() == 0) {
            return;
        }
        int netAvailablePigeonSize = 0;
        int maxSlaveWaitTime = 60;
        for (int currWaitTime = 0; pigeonServiceInfoSet.size() != 0 && (netAvailablePigeonSize < slaveNum || currWaitTime < maxSlaveWaitTime); ++currWaitTime) {
            Iterator iterator = pigeonServiceInfoSet.iterator();
            while (iterator.hasNext()) {
                ServiceInfo tempServiceInfo2 = (ServiceInfo)iterator.next();
                if (ServiceInfoManager.rpcPortNetTest(tempServiceInfo2)) {
                    iterator.remove();
                    ++netAvailablePigeonSize;
                    newInstanceId2serviceInfoMap.put(tempServiceInfo2.getInstanceId(), tempServiceInfo2);
                    continue;
                }
                Boolean isdown = (Boolean)downInstanceIdCache.getOrDefault((Object)tempServiceInfo2.getInstanceId(), (Object)false);
                if (!Boolean.TRUE.equals(isdown)) continue;
                iterator.remove();
            }
            if (pigeonServiceInfoSet.size() == 0) continue;
            LockSupport.parkNanos(500000000L);
        }
    }

    private static void executionServiceInfoFirstInit(Map<String, ServiceInfo> newInstanceId2serviceInfoMap, Map<String, ServiceInfo> innerInstanceId2serviceInfoMap) {
        ServiceInfo tempServiceInfo;
        HashSet<ServiceInfo> executionServiceInfoSet = new HashSet<ServiceInfo>(innerInstanceId2serviceInfoMap.size());
        String myInstanceId = Instance.getInstanceId();
        if (Instance.isAppSplit()) {
            for (Map.Entry<String, ServiceInfo> tempEntry : innerInstanceId2serviceInfoMap.entrySet()) {
                tempServiceInfo = tempEntry.getValue();
                if (tempServiceInfo.getInstanceId().equals(myInstanceId) || tempServiceInfo.getAppIds() == null || tempServiceInfo.getAppIds().length <= 0 || Arrays.asList(tempServiceInfo.getAppIds()).contains("pigeon")) continue;
                executionServiceInfoSet.add(tempServiceInfo);
            }
        } else {
            for (Map.Entry<String, ServiceInfo> tempEntry : innerInstanceId2serviceInfoMap.entrySet()) {
                tempServiceInfo = tempEntry.getValue();
                if (tempServiceInfo.getInstanceId().equals(myInstanceId)) continue;
                executionServiceInfoSet.add(tempServiceInfo);
            }
        }
        int maxSlaveWaitTime = 10;
        for (int currWaitTime = 0; executionServiceInfoSet.size() != 0 && currWaitTime < maxSlaveWaitTime; ++currWaitTime) {
            Iterator iterator = executionServiceInfoSet.iterator();
            while (iterator.hasNext()) {
                ServiceInfo tempServiceInfo2 = (ServiceInfo)iterator.next();
                if (ServiceInfoManager.rpcPortNetTest(tempServiceInfo2)) {
                    iterator.remove();
                    newInstanceId2serviceInfoMap.put(tempServiceInfo2.getInstanceId(), tempServiceInfo2);
                    continue;
                }
                Boolean isdown = (Boolean)downInstanceIdCache.getOrDefault((Object)tempServiceInfo2.getInstanceId(), (Object)false);
                if (!Boolean.TRUE.equals(isdown)) continue;
                iterator.remove();
            }
            if (executionServiceInfoSet.size() == 0) continue;
            LockSupport.parkNanos(500000000L);
        }
    }

    private static void updateServiceInfo(boolean notifyServiceEventEnable) {
        try {
            Map<String, ServiceInfo> allOriginServiceInfos = ServiceInfoManager.getAllOriginServiceInfos();
            if (allOriginServiceInfos == null) {
                return;
            }
            HashMap<String, ServiceInfo> oldInstanceId2serviceInfoMap = new HashMap<String, ServiceInfo>(instanceId2serviceInfoMap.get());
            ServiceInfoManager.updateNetAvailable(allOriginServiceInfos);
            if (notifyServiceEventEnable) {
                ServiceInfoManager.notifyServiceEvent(oldInstanceId2serviceInfoMap, instanceId2serviceInfoMap.get());
            }
        }
        catch (Exception e) {
            LOGGER.error("updateServiceInfo error", (Throwable)e);
        }
    }

    private static void updateNetAvailable(Map<String, ServiceInfo> innerInstanceId2serviceInfoMap) {
        try {
            ServiceInfo tempServiceInfo;
            ConcurrentHashMap<String, ServiceInfo> newInstanceId2serviceInfoMap = new ConcurrentHashMap<String, ServiceInfo>();
            ConcurrentHashMap<String, Set> newAppId2serviceInfoSetMap = new ConcurrentHashMap<String, Set>();
            HashMap<String, ServiceInfo> copyInnerInstanceId2serviceInfoMap = new HashMap<String, ServiceInfo>(innerInstanceId2serviceInfoMap);
            Iterator iterator = copyInnerInstanceId2serviceInfoMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry tempEntry = iterator.next();
                String tempInstanceId = (String)tempEntry.getKey();
                tempServiceInfo = (ServiceInfo)tempEntry.getValue();
                Boolean cacheStatus = (Boolean)instanceId2ServiceRpcStatus.get((Object)tempInstanceId);
                if ((cacheStatus == null || !cacheStatus.booleanValue()) && !ServiceInfoManager.rpcPortNetTest(tempServiceInfo)) continue;
                newInstanceId2serviceInfoMap.put(tempInstanceId, tempServiceInfo);
                iterator.remove();
            }
            if (!copyInnerInstanceId2serviceInfoMap.isEmpty()) {
                LOGGER.info("net check error, delay check again. instanceIds:{}", copyInnerInstanceId2serviceInfoMap.keySet());
                backgroundCheckTimes.set(300);
                backgroundCheckServiceInfoMap.clear();
                backgroundCheckServiceInfoMap.putAll(copyInnerInstanceId2serviceInfoMap);
                ServiceInfoManager.notifyCheckNetAvailableBackground();
            }
            for (Map.Entry entry : newInstanceId2serviceInfoMap.entrySet()) {
                tempServiceInfo = (ServiceInfo)entry.getValue();
                if (!Instance.isAppSplit()) {
                    Set tempServiceInfoSet = newAppId2serviceInfoSetMap.computeIfAbsent("all", key -> new HashSet());
                    tempServiceInfoSet.add(tempServiceInfo);
                    continue;
                }
                String[] tempAppIdArray = tempServiceInfo.getAppIds();
                if (tempAppIdArray == null || tempAppIdArray.length <= 0) continue;
                for (String tempAppId : tempAppIdArray) {
                    Set tempServiceInfoSet = newAppId2serviceInfoSetMap.computeIfAbsent(tempAppId, key -> new HashSet());
                    tempServiceInfoSet.add(tempServiceInfo);
                }
            }
            instanceId2serviceInfoMap.set(newInstanceId2serviceInfoMap);
            appId2serviceInfoSetMap.set(newAppId2serviceInfoSetMap);
        }
        catch (Exception e) {
            LOGGER.error("updateNetAvailableServiceError", (Throwable)e);
        }
    }

    private static void notifyCheckNetAvailableBackground() {
        if (backgroundCheckTimes.get() < 0) {
            return;
        }
        int flag = backgroundCheckCount.incrementAndGet();
        ServiceInfoManager.runInPipe(() -> {
            if (flag == backgroundCheckCount.get()) {
                ServiceInfoManager.checkNetAvailableBackground();
            }
        });
    }

    private static void checkNetAvailableBackground() {
        if (backgroundCheckTimes.decrementAndGet() < 0) {
            return;
        }
        try {
            Set<String> keySet = backgroundCheckServiceInfoMap.keySet();
            if (keySet.isEmpty()) {
                return;
            }
            for (String tempInstanceId : keySet) {
                ServiceInfo tempServiceInfo = backgroundCheckServiceInfoMap.get(tempInstanceId);
                if (tempServiceInfo == null) continue;
                Boolean isdown = (Boolean)downInstanceIdCache.getOrDefault((Object)tempInstanceId, (Object)false);
                Boolean cacheStatus = (Boolean)instanceId2ServiceRpcStatus.getOrDefault((Object)tempInstanceId, (Object)false);
                if (!isdown.booleanValue() && !cacheStatus.booleanValue() && !ServiceInfoManager.rpcPortNetTest(tempServiceInfo)) continue;
                backgroundCheckServiceInfoMap.remove(tempInstanceId);
                ServiceInfoManager.asyncNotifyUpdateServiceInfo(true);
            }
            if (!backgroundCheckServiceInfoMap.isEmpty()) {
                LockSupport.parkNanos(500000000L);
            }
            if (!backgroundCheckServiceInfoMap.isEmpty()) {
                ServiceInfoManager.notifyCheckNetAvailableBackground();
            }
        }
        catch (Exception e) {
            LOGGER.error("checkNetAvailableBackgroundError", (Throwable)e);
        }
    }

    static boolean rpcPortNetTest(ServiceInfo serviceInfo) {
        if (currServiceInfo != null && Objects.equals(serviceInfo.getInstanceId(), currServiceInfo.getInstanceId())) {
            return true;
        }
        boolean flag = false;
        if (!StringUtils.isEmpty((String)serviceInfo.getRpcPort())) {
            try (Socket socket = new Socket();){
                socket.connect(new InetSocketAddress(serviceInfo.getIp(), Integer.parseInt(serviceInfo.getRpcPort())), 1000);
                try {
                    if (ServiceInfoManager.pingPongTest(serviceInfo.getIp(), serviceInfo.getRpcPort(), serviceInfo.getInstanceId())) {
                        flag = true;
                        instanceId2ServiceRpcStatus.put((Object)serviceInfo.getInstanceId(), (Object)true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.info("rpcPortNetTest {}:{} {}:{}", new Object[]{flag ? "ok" : "error", serviceInfo.getInstanceId(), serviceInfo.getIp(), serviceInfo.getRpcPort()});
        }
        return flag;
    }

    public static boolean pingPongTest(String ip, String rpcPort, String instanceId) {
        if (currServiceInfo != null && Objects.equals(instanceId, currServiceInfo.getInstanceId())) {
            return true;
        }
        boolean flag = false;
        try {
            PigeonRequestContextUtil.createRpcRequestContext();
            Object pingResult = EndPointInvokeServiceHelper.invoke((String)ip, (String)rpcPort, (String)"kd.bos.pigeon.elect.ElectorService", (String)"ping", (Object[])new Object[]{instanceId});
            if (pingResult != null && pingResult.toString().equals("pong")) {
                flag = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ping-pong test {}:{} {}", new Object[]{flag ? "ok" : "error", instanceId, ip + ":" + rpcPort});
        }
        return flag;
    }

    private static void notifyServiceEvent(Map<String, ServiceInfo> oldInnerInstanceId2serviceInfoMap, Map<String, ServiceInfo> newInnerInstanceId2serviceInfoMap) {
        Set upInstanceIdSet;
        Set<String> newInstanceIdSet = newInnerInstanceId2serviceInfoMap.keySet();
        Set<String> oldInstanceIdSet = oldInnerInstanceId2serviceInfoMap.keySet();
        Set downInstanceIdSet = oldInstanceIdSet.stream().filter(e -> !newInstanceIdSet.contains(e)).collect(Collectors.toCollection(HashSet::new));
        if (downInstanceIdSet.size() > 0) {
            for (String tempInstanceId : downInstanceIdSet) {
                threadPool.execute(() -> ServiceEventManager.fireServiceEvent(ServiceEvent.DOWN, (ServiceInfo)oldInnerInstanceId2serviceInfoMap.get(tempInstanceId)));
                instanceId2ServiceRpcStatus.remove((Object)tempInstanceId);
            }
        }
        if ((upInstanceIdSet = (Set)newInstanceIdSet.stream().filter(e -> !oldInstanceIdSet.contains(e)).collect(Collectors.toCollection(HashSet::new))).size() > 0) {
            for (String tempInstanceId : upInstanceIdSet) {
                threadPool.execute(() -> ServiceEventManager.fireServiceEvent(ServiceEvent.UP, (ServiceInfo)newInnerInstanceId2serviceInfoMap.get(tempInstanceId)));
            }
        }
    }

    public static Set<ServiceInfo> getServiceInfoSetByAppId(String appId) {
        return appId2serviceInfoSetMap.get().get(appId);
    }

    public static ServiceInfo getServiceInfoByInstanceId(String instanceId) {
        return instanceId2serviceInfoMap.get().get(instanceId);
    }

    public static ServiceInfo getCurrServiceInfo() {
        return currServiceInfo;
    }

    public static Set<ServiceInfo> getCopyAllServiceInfoSet() {
        Map<String, ServiceInfo> infoMap = instanceId2serviceInfoMap.get();
        HashSet<ServiceInfo> allServiceInfoSet = new HashSet<ServiceInfo>(infoMap.size() * 2);
        Collection<ServiceInfo> serviceInfoCollection = infoMap.values();
        allServiceInfoSet.addAll(serviceInfoCollection);
        return allServiceInfoSet;
    }

    static {
        isServiceObserverInit = new AtomicBoolean(false);
        onChangeCount = new AtomicInteger();
    }
}

