/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.exception;

import feign.Request;
import java.util.Locale;
import kd.bos.mservice.common.exception.RpcErrorCode;
import kd.bos.mservice.common.exception.RpcErrorInfo;
import kd.bos.mservice.common.rpc.FeignRequsetParam;
import kd.bos.mservice.common.rpc.RegisterAppNameUtils;
import kd.bos.mservice.sdk.bundle.SdkResources;
import kd.bos.mservice.sdk.thread.InnerThreadTruck;
import kd.bos.mservice.sdk.util.SdkStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionStandardHandler {
    private static Logger LOG = LoggerFactory.getLogger(ExceptionStandardHandler.class);

    public static String getFeignStandardErrorMessage(Request request, RpcErrorInfo rpcErrorInfo) {
        String appId = RegisterAppNameUtils.getRequestAppID();
        if (rpcErrorInfo.getApiName() == null) {
            FeignRequsetParam feignRequsetParam = RegisterAppNameUtils.getRequestFeignParam();
            String fullApiName = ExceptionStandardHandler.getApiName(request, feignRequsetParam.getParams(), appId);
            rpcErrorInfo.setApiName(fullApiName);
        }
        if (rpcErrorInfo.getAppIdName() == null) {
            rpcErrorInfo.setAppIdName(ExceptionStandardHandler.getAppIdName(appId));
        }
        String errorMsg = RpcErrorCode.getMsgByCode((RpcErrorInfo)rpcErrorInfo);
        return errorMsg;
    }

    public static String getRestTemplateStandardErrorMessage(RpcErrorInfo rpcErrorInfo) {
        if (rpcErrorInfo.getAppIdName() == null && rpcErrorInfo.getAppId() != null) {
            rpcErrorInfo.setAppIdName(ExceptionStandardHandler.getAppIdName(rpcErrorInfo.getAppId()));
        }
        String errorMsg = RpcErrorCode.getMsgByCode((RpcErrorInfo)rpcErrorInfo);
        return errorMsg;
    }

    private static String getAppIdName(String appId) {
        String appgroup = RegisterAppNameUtils.getGroupName((String)appId);
        appgroup = "defaultGroup".equals(appgroup) ? "" : appgroup + ".";
        String appIdName = ExceptionStandardHandler.getAppIdNameByResources(appId);
        appIdName = (appIdName == null ? "" : appIdName) + (appId == null ? "" : "(" + appgroup + appId + ")");
        return appIdName;
    }

    private static String getApiName(Request request, Object[] args, String appId) {
        if (request.url().endsWith("kdDispatchServiceFeign") && args != null && args.length > 2) {
            String urlMethodName;
            StringBuilder apiNameBuild = new StringBuilder();
            String serviceName = String.valueOf(args[1]);
            String methodName = String.valueOf(args[2]);
            if ("batchInvokeAction".equals(methodName) && SdkStringUtils.isNotEmpty((String)(urlMethodName = (String)InnerThreadTruck.get((Object)"batchInvokeAction")))) {
                methodName = "(" + urlMethodName.replace(appId + ".", "") + ")";
            }
            String fullApiName = apiNameBuild.append(serviceName).append(":").append(methodName).toString();
            return fullApiName;
        }
        return request.requestTemplate().methodMetadata().configKey();
    }

    public static String getAppIdNameByResources(String appId) {
        try {
            return SdkStringUtils.isEmpty((String)appId) ? "" : SdkResources.get((String)"appid", (String)appId.toUpperCase(Locale.ENGLISH), (String)"AppIdName", (Object[])new Object[0]);
        }
        catch (Error | Exception e) {
            LOG.warn("ExceptionStandardHandler getAppIdNameByResources exception", e);
            return "";
        }
    }
}

