/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.codec;

import feign.FeignException;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.util.Collection;
import kd.bos.mservice.common.exception.RpcErrorCode;
import kd.bos.mservice.common.exception.RpcErrorInfo;
import kd.bos.mservice.common.exception.RpcException;
import kd.bos.mservice.rpc.exception.ExceptionStandardHandler;
import kd.bos.mservice.serialization.KServiceSerializationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KDErrorDecoder
extends ErrorDecoder.Default {
    private static final Logger log = LoggerFactory.getLogger(KDErrorDecoder.class);

    public Exception decode(String s, Response response) {
        if (response.body() == null) {
            String msg = "feign response`s body is null";
            log.error(msg);
            throw new RpcException(msg);
        }
        Collection collection = (Collection)response.headers().get("content-type");
        if (collection != null) {
            collection.forEach(contentType -> {
                if (contentType.contains("application/xx-kd-serialization")) {
                    Object errMsg;
                    try {
                        errMsg = KServiceSerializationFactory.getDefaultBinarySerializer().deserialize(response.body().asInputStream(), null);
                    }
                    catch (IOException e) {
                        log.warn("KDErrorDecoder getDefaultBinarySerializer deserialize error", (Throwable)e);
                        throw new RpcException.RpcClientException("KDErrorDecoder getDefaultBinarySerializer deserialize error", (Throwable)e);
                    }
                    if (errMsg instanceof String) {
                        throw new RpcException.RpcServerException((String)errMsg);
                    }
                    if (errMsg instanceof RpcException.RpcServerException) {
                        log.error("Server exception:", (Throwable)((RpcException.RpcServerException)errMsg));
                        throw (RpcException.RpcServerException)errMsg;
                    }
                    if (errMsg instanceof Throwable) {
                        log.error("Server exception:", errMsg);
                        throw new RpcException.RpcServerException((Throwable)errMsg);
                    }
                    if (!(errMsg instanceof String)) {
                        String err = "Received an exception object that cannot be resolved, unknown exception on the server";
                        log.warn(err, errMsg);
                        throw new RpcException(err);
                    }
                }
            });
        }
        try {
            Exception exception = super.decode(s, response);
            if (exception instanceof FeignException.ServiceUnavailable) {
                RpcErrorInfo rpcErrorInfo = new RpcErrorInfo();
                rpcErrorInfo.setErrorCode(RpcErrorCode.consumerInvokerNotFound.getCode());
                s = ExceptionStandardHandler.getFeignStandardErrorMessage(response.request(), rpcErrorInfo);
                log.error(s);
                throw new RpcException.RpcServiceUnavailableException(s);
            }
            return exception;
        }
        catch (Exception e) {
            if (e instanceof RpcException) {
                throw e;
            }
            log.error("KDErrorDecoder parse contentType of toString error", (Throwable)e);
            throw new RpcException("KDErrorDecoder parse contentType of toString error", (Throwable)e);
        }
    }
}

