/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.configuration;

import feign.Client;
import kd.bos.mservice.rpc.feign.httpclient.ApacheHttpClient;
import kd.bos.mservice.rpc.feign.loadbalance.BosLoadBalancerFeignClient;
import kd.bos.mservice.rpc.handshake.ClientTypeEnum;
import kd.bos.mservice.rpc.handshake.HandshakeServiceFactory;
import kd.bos.mservice.rpc.handshake.client.impl.ApacheHttpHandshakeClient;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(name={"feign.config.auto"}, havingValue="true", matchIfMissing=true)
@ConditionalOnMissingClass(value={"org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerClient", "kd.bos.mservice.rpc.feign.httpclient.KdApacheHttpClient"})
@Configuration
public class FeignDefaultClientConfiguration {
    @Bean
    public Client feignClient(LoadBalancerClient loadBalancerClient, LoadBalancerClientFactory loadBalancerClientFactory) {
        if (Boolean.getBoolean("feign.apacheclient.disable")) {
            return new BosLoadBalancerFeignClient((Client)new Client.Default(null, null), loadBalancerClient, loadBalancerClientFactory);
        }
        CloseableHttpClient builder = HttpClientBuilder.create().setMaxConnTotal(Integer.parseInt(System.getProperty("mservice.apache.httpclient.maxTotal", "200"))).setMaxConnPerRoute(Integer.parseInt(System.getProperty("mservice.apache.httpclient.maxConnPerRoute", "50"))).build();
        HandshakeServiceFactory.create(ClientTypeEnum.APACHE_HTTP, new ApacheHttpHandshakeClient((HttpClient)builder));
        return new BosLoadBalancerFeignClient(new ApacheHttpClient((HttpClient)builder), loadBalancerClient, loadBalancerClientFactory);
    }
}

