/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.interceptor;

import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.ServiceLoader;
import kd.bos.mservice.common.ServiceEnv;
import kd.bos.mservice.common.rpc.FeignRequsetParam;
import kd.bos.mservice.common.rpc.RegisterAppNameUtils;
import kd.bos.mservice.rpc.feign.ThridHeadProvider;
import kd.bos.mservice.rpc.feign.annotation.EnableTianShuInvoke;
import kd.bos.mservice.sdk.thread.InnerThreadTruck;
import kd.bos.mservice.sdk.util.SdkStringUtils;
import kd.bos.mservice.serialization.KServiceSerializationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

public class FeignRequestInterceptor
implements RequestInterceptor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(FeignRequestInterceptor.class);
    private static final String REQUEST_DISPATCH_SERVICE_FEIGN = "/kdDispatchServiceFeign";
    private static final String FEIGN_KD_CONVERTER_SERVICE_REQUEST = "/kdConverterServiceRequest";
    private static final FeignRequsetParam fparam = new FeignRequsetParam();
    private static final String contextPath = System.getProperty("feign.client.context.path", "ierp");
    private static final boolean isFeignConverterEnable = Boolean.parseBoolean(System.getProperty("mservice.feign.converter.enable", "true"));
    private static final boolean isRegisterWithAppName = Boolean.getBoolean("mservice.feign.register.withappname");
    private final ServiceLoader<ThridHeadProvider> thridHeadloader = ServiceLoader.load(ThridHeadProvider.class);

    public FeignRequestInterceptor() {
        fparam.setInterfaceName("kd.bos.service.InvokeService");
        fparam.setMethodName("invoke");
    }

    public void apply(RequestTemplate requestTemplate) {
        if (ServiceEnv.isTianShuService()) {
            this.setHeaderIfEmpty(requestTemplate, "isTianshu", Boolean.TRUE.toString());
        }
        if (REQUEST_DISPATCH_SERVICE_FEIGN.equals(requestTemplate.url())) {
            InnerThreadTruck.put((Object)"kdConvertAppIdToAppNameEnable", (Object)"true");
            String codeType = RegisterAppNameUtils.getRequestCodecType();
            if (SdkStringUtils.isNotEmpty((String)codeType)) {
                this.setHeaderIfEmpty(requestTemplate, "codecType", "json");
            } else {
                this.setHeaderIfEmpty(requestTemplate, "codecType", "javaobj");
            }
            return;
        }
        boolean isKdConvertUrlEnable = this.isKdConvertUrlEnable(requestTemplate);
        if (isKdConvertUrlEnable) {
            RegisterAppNameUtils.setRequestFeignParam((FeignRequsetParam)fparam);
            this.build(requestTemplate);
            requestTemplate.uri(FEIGN_KD_CONVERTER_SERVICE_REQUEST);
            if (Request.HttpMethod.GET.name().endsWith(requestTemplate.method())) {
                requestTemplate.method(Request.HttpMethod.POST);
                ByteArrayOutputStream bytesOutput = new ByteArrayOutputStream();
                KServiceSerializationFactory.getDefaultBinarySerializer().serialize(InnerThreadTruck.get((Object)"commonRpcParam"), (OutputStream)bytesOutput);
                requestTemplate.body(bytesOutput.toByteArray(), null);
                requestTemplate.queries(null);
                InnerThreadTruck.remove((Object)"commonRpcParam");
            }
        } else {
            this.setThridHead(requestTemplate);
        }
    }

    private void setThridHead(RequestTemplate requestTemplate) {
        for (ThridHeadProvider loader : this.thridHeadloader) {
            Map<String, String> heads = loader.customHeaders();
            heads.forEach((k, v) -> this.setHeaderIfEmpty(requestTemplate, (String)k, (String)v));
        }
    }

    private boolean isKdConvertUrlEnable(RequestTemplate requestTemplate) {
        if (!isFeignConverterEnable) {
            if (isRegisterWithAppName) {
                InnerThreadTruck.put((Object)"kdConvertAppIdToAppNameEnable", (Object)"true");
            }
            return false;
        }
        EnableTianShuInvoke annotation = requestTemplate.feignTarget().type().getAnnotation(EnableTianShuInvoke.class);
        boolean isTianShuService = ServiceEnv.isTianShuService();
        if (annotation == null) {
            if (isTianShuService) {
                InnerThreadTruck.put((Object)"kdConvertAppIdToAppNameEnable", (Object)"true");
                return true;
            }
        } else if (annotation != null) {
            if (!isTianShuService && annotation.value()) {
                InnerThreadTruck.put((Object)"kdConvertAppIdToAppNameEnable", (Object)"true");
                return true;
            }
            if (isTianShuService && !annotation.value()) {
                InnerThreadTruck.put((Object)"kdConvertAppIdToAppNameEnable", (Object)"false");
                InnerThreadTruck.put((Object)"tianshuInvokeOutService", (Object)"true");
                return false;
            }
            if (isTianShuService && annotation.value()) {
                InnerThreadTruck.put((Object)"kdConvertAppIdToAppNameEnable", (Object)"true");
                return true;
            }
        }
        return false;
    }

    private void build(RequestTemplate requestTemplate) {
        String url = requestTemplate.feignTarget().url();
        if (!url.contains(contextPath)) {
            return;
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        URI targetUri = URI.create(url);
        String[] parts = url.split(contextPath);
        if (parts.length == 2) {
            this.buildOriginal(requestTemplate, parts[1]);
            String target = targetUri.getScheme() + "://" + targetUri.getAuthority() + "/" + contextPath;
            requestTemplate.target(target);
        } else {
            this.buildOriginal(requestTemplate, "");
        }
    }

    private void buildOriginal(RequestTemplate requestTemplate, String prefixPath) {
        String suffixUri = requestTemplate.url();
        String OriginalUri = prefixPath + suffixUri;
        int splitIndex = OriginalUri.indexOf("?");
        this.setHeaderIfEmpty(requestTemplate, "originalUri", splitIndex > 0 ? OriginalUri.substring(0, splitIndex) : OriginalUri);
    }

    private boolean isJavaobjCodeType(RequestTemplate requestTemplate) {
        Collection collections = (Collection)requestTemplate.headers().get("codecType");
        if (collections == null || collections.isEmpty()) {
            return false;
        }
        for (String type : collections) {
            if (!KServiceSerializationFactory.isBinarySerialization((String)type)) continue;
            return true;
        }
        return false;
    }

    private void setHeaderIfEmpty(RequestTemplate requestTemplate, String key, String value) {
        Collection collections = (Collection)requestTemplate.headers().get(key);
        if (collections == null || collections.isEmpty()) {
            requestTemplate.header(key, new String[]{value});
        }
    }

    public int getOrder() {
        return 0;
    }
}

