/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.feign.loadbalance;

import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.concurrent.locks.LockSupport;
import kd.bos.mservice.common.exception.RpcErrorInfo;
import kd.bos.mservice.common.exception.RpcException;
import kd.bos.mservice.common.rpc.FeignRequsetParam;
import kd.bos.mservice.common.rpc.RegisterAppNameUtils;
import kd.bos.mservice.rpc.exception.ExceptionStandardHandler;
import kd.bos.mservice.sdk.thread.InnerThreadTruck;
import kd.bos.mservice.sdk.util.SdkNetAddressUtils;
import kd.bos.mservice.sdk.util.SdkStringUtils;
import org.apache.http.NoHttpResponseException;
import org.apache.http.conn.HttpHostConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;

public class BosLoadBalancerFeignClient
extends FeignBlockingLoadBalancerClient {
    private static final Logger log = LoggerFactory.getLogger(BosLoadBalancerFeignClient.class);
    private static final Field urlField;

    public BosLoadBalancerFeignClient(Client delegate, LoadBalancerClient loadBalancerClient, LoadBalancerClientFactory loadBalancerClientFactory) {
        super(delegate, loadBalancerClient, loadBalancerClientFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response execute(Request request, Request.Options options) throws IOException {
        String clientName;
        if (!"true".equals(InnerThreadTruck.get((Object)"kdConvertAppIdToAppNameEnable"))) {
            try {
                Response response = super.execute(request, options);
                return response;
            }
            finally {
                InnerThreadTruck.remove((Object)"kdConvertAppIdToAppNameEnable");
            }
        }
        String appName = this.getAppName();
        try {
            URI asUri = URI.create(request.url());
            clientName = asUri.getHost();
            if (!SdkStringUtils.isEmpty((String)clientName) && !clientName.equals(appName)) {
                urlField.setAccessible(true);
                urlField.set(request, request.url().replaceFirst(clientName, appName));
            }
        }
        catch (Exception e) {
            log.error("OpenFeign rpc exception ,Server:" + appName + ",errMessage:" + e.getMessage(), (Throwable)e);
            throw new RpcException("OpenFeign rpc exception,Server:" + appName + ",errMessage:" + e.getMessage(), (Throwable)e);
        }
        try {
            block21: {
                String host = RegisterAppNameUtils.getRequestHost();
                try {
                    if (!SdkStringUtils.isNotEmpty((String)host)) break block21;
                    clientName = super.getDelegate().execute(request, options);
                    return clientName;
                }
                catch (NoHttpResponseException | HttpHostConnectException he) {
                    if (he instanceof HttpHostConnectException) {
                        log.warn(host + " is not available and will retry anotherserver", he);
                    } else if (he instanceof NoHttpResponseException) {
                        log.warn("NoHttpResponseException and will try again ", he);
                        LockSupport.parkNanos(50000000L);
                    }
                    if (SdkStringUtils.isNotEmpty((String)host)) {
                        Response response = super.getDelegate().execute(request, options);
                        return response;
                    }
                    Response response = super.execute(request, options);
                    return response;
                }
            }
            clientName = super.execute(request, options);
            return clientName;
        }
        catch (Exception e) {
            this.handleException(request, e);
            log.error("OpenFeign rpc exception ,Server:" + appName + ",errMessage:" + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            InnerThreadTruck.remove((Object)"kdConvertAppIdToAppNameEnable");
        }
    }

    private String getAppName() {
        String appName;
        String host = RegisterAppNameUtils.getRequestHost();
        if (SdkStringUtils.isNotEmpty((String)host)) {
            appName = this.extractIPv6FromHost(host);
        } else {
            String appid = RegisterAppNameUtils.getRequestAppID();
            FeignRequsetParam feignRequsetParam = RegisterAppNameUtils.getRequestFeignParam();
            appName = appid == null ? RegisterAppNameUtils.getRegisterInterfaceName((String)feignRequsetParam.getInterfaceName()) : RegisterAppNameUtils.getLookupAppName((String)RegisterAppNameUtils.getOriginaRequestAppID());
        }
        return appName;
    }

    private String extractIPv6FromHost(String host) {
        if (!SdkNetAddressUtils.isPreferIPv6()) {
            return host;
        }
        if (host.startsWith("[") && host.contains("]")) {
            return host;
        }
        int lastColonIndex = host.lastIndexOf(58);
        String addressPart = host.substring(0, lastColonIndex);
        String portPart = host.substring(lastColonIndex + 1);
        return "[" + addressPart + "]:" + portPart;
    }

    private void handleException(Request request, Exception e) {
        if (e instanceof RpcException.RpcTimeoutException) {
            RpcErrorInfo rpcErrorInfo = new RpcErrorInfo();
            RpcException.RpcTimeoutException rpcTimeoutException = (RpcException.RpcTimeoutException)e;
            rpcErrorInfo.setErrorCode(rpcTimeoutException.getErrorCode());
            rpcErrorInfo.setCostTime(rpcTimeoutException.getCostTime());
            rpcErrorInfo.setTimeout(rpcTimeoutException.getTimeout());
            rpcErrorInfo.setRemoteIp(rpcTimeoutException.getRemoteIp());
            String errorMessage = ExceptionStandardHandler.getFeignStandardErrorMessage(request, rpcErrorInfo);
            ((RpcException.RpcTimeoutException)e).setErrorMessage(errorMessage);
            log.error(errorMessage, (Throwable)e);
            throw new RpcException.RpcTimeoutException(errorMessage);
        }
        if (e instanceof RpcException.RpcServiceUnavailableException) {
            RpcErrorInfo rpcErrorInfo = new RpcErrorInfo();
            RpcException.RpcServiceUnavailableException unavailableException = (RpcException.RpcServiceUnavailableException)e;
            rpcErrorInfo.setErrorCode(unavailableException.getErrorCode());
            String errorMessage = ExceptionStandardHandler.getFeignStandardErrorMessage(request, rpcErrorInfo);
            log.error(errorMessage, (Throwable)e);
            throw new RpcException.RpcServiceUnavailableException(errorMessage);
        }
    }

    static {
        try {
            urlField = Request.class.getDeclaredField("url");
        }
        catch (NoSuchFieldException e) {
            log.error("OpenFeign rpc exception when get field Feign.Request.url" + e.getMessage(), (Throwable)e);
            throw new RpcException("OpenFeign rpc exception when get field Feign.Request.url" + e.getMessage(), (Throwable)e);
        }
    }
}

