/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.handshake;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.mservice.rpc.handshake.ClientTypeEnum;
import kd.bos.mservice.rpc.handshake.HandshakeService;
import kd.bos.mservice.rpc.handshake.client.HandshakeClient;
import kd.bos.mservice.rpc.handshake.entity.HandShakeRequest;
import kd.bos.mservice.rpc.handshake.entity.HandShakeResponse;

public class HandshakeServiceFactory {
    private static Map<ClientTypeEnum, HandshakeService> handshakeServiceMap = new ConcurrentHashMap<ClientTypeEnum, HandshakeService>(1);

    public static HandshakeService create(ClientTypeEnum typeEnum, HandshakeClient handshakeClient) {
        return handshakeServiceMap.computeIfAbsent(typeEnum, key -> new DefaultHandshakeService(handshakeClient));
    }

    public static HandshakeService get(ClientTypeEnum typeEnum) {
        return handshakeServiceMap.get((Object)typeEnum);
    }

    private static class DefaultHandshakeService
    implements HandshakeService {
        private final HandshakeClient handshakeClient;

        public DefaultHandshakeService(HandshakeClient handshakeClient) {
            this.handshakeClient = handshakeClient;
        }

        @Override
        public HandShakeResponse handshake(HandShakeRequest handShakeRequest) {
            return this.handshakeClient.execute(handShakeRequest);
        }
    }
}

