/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.handshake.client.impl;

import kd.bos.mservice.context.BaseContext;
import kd.bos.mservice.context.KdBaseContextCodec;
import kd.bos.mservice.rpc.handshake.client.HandshakeClient;
import kd.bos.mservice.rpc.handshake.entity.HandShakeException;
import kd.bos.mservice.rpc.handshake.entity.HandShakeRequest;
import kd.bos.mservice.rpc.handshake.entity.HandShakeResponse;
import kd.bos.mservice.rpc.handshake.entity.HandShakeStatus;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpHandshakeClient
implements HandshakeClient {
    private static final Logger log = LoggerFactory.getLogger(ApacheHttpHandshakeClient.class);
    private static final String KD_HAND_SHAKE_URL = System.getProperty("feign.client.context.path") + "/health/handShake";
    private final HttpClient httpClient;
    private final RequestConfig requestConfig;

    public ApacheHttpHandshakeClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.requestConfig = RequestConfig.custom().setConnectTimeout(Integer.getInteger("mservice.handshake.connect.timeout", 800).intValue()).setSocketTimeout(Integer.getInteger("mservice.handshake.read.timeout", 800).intValue()).setConnectionRequestTimeout(Integer.getInteger("mservice.handshake.connection.pool.timeout", 50).intValue()).build();
    }

    @Override
    public HandShakeResponse execute(HandShakeRequest handShakeRequest) {
        HandShakeResponse response;
        try {
            HttpPost httpPost = new HttpPost("http://" + handShakeRequest.getIpPort() + KD_HAND_SHAKE_URL);
            if (Boolean.getBoolean("mservice.auth.enable") && Boolean.getBoolean("mservice.auth.handshake.enable")) {
                httpPost.setHeader("rpcContext", KdBaseContextCodec.encode((BaseContext)BaseContext.get()));
            }
            httpPost.setHeader("code", String.valueOf(handShakeRequest.getCheckCode()));
            httpPost.setConfig(this.requestConfig);
            long begin = 0L;
            try {
                begin = System.currentTimeMillis();
                HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
                response = this.convertHttpResponseToHandShakeResponse(httpResponse);
            }
            catch (Exception e) {
                httpPost.setConfig(RequestConfig.custom().setConnectTimeout(this.requestConfig.getConnectTimeout() / 2).setSocketTimeout(this.requestConfig.getSocketTimeout() / 2).setConnectionRequestTimeout(this.requestConfig.getConnectionRequestTimeout() / 2).build());
                begin = System.currentTimeMillis();
                HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
                response = this.convertHttpResponseToHandShakeResponse(httpResponse);
            }
            if (handShakeRequest.getCheckCode() != response.getCheckCode()) {
                throw new HandShakeException("hand shake checkcode error!");
            }
            if (HandShakeStatus.REFUSE == response.getStatus()) {
                throw new HandShakeException("overload limit error,server refuse this requset!");
            }
            response.setCost(System.currentTimeMillis() - begin);
        }
        catch (Throwable e) {
            if (e instanceof ConnectionPoolTimeoutException) {
                log.warn("Handshake get connection from Connection pool timeout", e);
            }
            response = new HandShakeResponse(handShakeRequest.getCheckCode());
            if (e instanceof HandShakeException) {
                response.setException(e);
            }
            response.setException(new HandShakeException("handshake error!", e));
        }
        return response;
    }

    private HandShakeResponse convertHttpResponseToHandShakeResponse(HttpResponse httpResponse) {
        String checkCode = httpResponse.getHeaders("code")[0].getValue();
        String handShakeStatus = httpResponse.getHeaders("HandShakeStatus")[0].getValue();
        return new HandShakeResponse(HandShakeStatus.valueOf(handShakeStatus), Long.parseLong(checkCode));
    }
}

