/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.handshake.entity;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class HandShakeFailedStatus {
    private AtomicLong lastFailedTime = new AtomicLong(0L);
    private AtomicLong lastBusyTime = new AtomicLong(0L);
    private AtomicLong retryIntevalTime = new AtomicLong(RETRYINTEVALTIMEINIT);
    private static final int RETRYINTEVALTIMEINIT = Integer.getInteger("mservice.handshake.initRetryIntevalMillis", 1000);
    private static int MAXRETRYINTEVAL = Integer.getInteger("mservice.handshake.maxRetryIntevalMillis", 60000);
    private AtomicLong recoveringHandShakeTime = new AtomicLong(0L);
    private AtomicBoolean isHandShakeBreak = new AtomicBoolean(false);

    public void sucessHandShake() {
        this.lastFailedTime.set(0L);
        if (this.retryIntevalTime.get() > (long)RETRYINTEVALTIMEINIT) {
            this.retryIntevalTime.addAndGet(-1000L);
        }
        this.retryIntevalTime.set(RETRYINTEVALTIMEINIT);
        this.recoveringHandShakeTime.set(0L);
        this.isHandShakeBreak.set(false);
    }

    public void failedHandShake() {
        this.lastFailedTime.set(System.currentTimeMillis());
        if (this.retryIntevalTime.get() < (long)MAXRETRYINTEVAL) {
            this.retryIntevalTime.addAndGet(1000L);
        }
        this.recoveringHandShakeTime.set(0L);
        this.isHandShakeBreak.set(true);
    }

    public void busyHandShake() {
        this.lastBusyTime.set(System.currentTimeMillis());
    }

    public boolean isBusyHandShake() {
        return System.currentTimeMillis() - this.lastBusyTime.get() < 3000L;
    }

    public boolean isHandShakeBreaked() {
        if (this.isHandShakeBreak.get()) {
            long cur = System.currentTimeMillis();
            if (this._isHandShakeBreadkedOverTime() && this.isNeedRecoveringBreak(cur)) {
                this.recoveringHandShakeTime.set(System.currentTimeMillis());
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isNeedRecoveringBreak(long cur) {
        return cur - this.recoveringHandShakeTime.get() > 3000L;
    }

    private boolean _isHandShakeBreadkedOverTime() {
        return this.lastFailedTime.get() == 0L || System.currentTimeMillis() - this.lastFailedTime.get() > this.retryIntevalTime.get();
    }

    public void limit(int i) {
    }
}

