/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.handshake.entity;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.mservice.sdk.instance.KdInstance;

public class RequestStatus {
    private static final Map<String, AtomicLong> appRequestCountMap = new ConcurrentHashMap<String, AtomicLong>(8);
    private static final AtomicLong totalRequest = new AtomicLong(1L);

    public static void requestApp(String appid) {
        if (!KdInstance.isAppSplit() || appid == null || appid.length() == 0) {
            return;
        }
        RequestStatus.get(appid).getAndIncrement();
        totalRequest.getAndIncrement();
    }

    public static boolean isAppRequestFrequency(String appid) {
        if (!KdInstance.isAppSplit() || appid == null || appid.length() == 0) {
            return true;
        }
        return (double)RequestStatus.get(appid).get() / (double)totalRequest.get() > 0.01;
    }

    private static AtomicLong get(String appid) {
        return appRequestCountMap.computeIfAbsent(appid, k -> new AtomicLong(0L));
    }
}

