/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.interceptor;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.mservice.rpc.interceptor.Interceptor;
import kd.bos.mservice.rpc.interceptor.chain.AbstractLinkedInterceptor;
import kd.bos.mservice.rpc.interceptor.chain.DefaultInterceptorChain;
import kd.bos.mservice.rpc.interceptor.chain.InterceptorChain;
import kd.bos.mservice.rpc.interceptor.spi.SpiLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptorChainProvider {
    private static final Logger log = LoggerFactory.getLogger(InterceptorChainProvider.class);
    private static final Map<String, InterceptorChain> chainMap = new ConcurrentHashMap<String, InterceptorChain>(2);

    public static InterceptorChain getConsumerChain() {
        InterceptorChain chain = chainMap.computeIfAbsent("consumer", key -> InterceptorChainProvider.newSlotChain("consumer"));
        return chain;
    }

    public static InterceptorChain getProviderChain() {
        InterceptorChain chain = chainMap.computeIfAbsent("provider", key -> InterceptorChainProvider.newSlotChain("provider"));
        return chain;
    }

    private static InterceptorChain newSlotChain(String role) {
        DefaultInterceptorChain chain = new DefaultInterceptorChain();
        List<Interceptor> sortedInterceptorList = SpiLoader.loadPrototypeInstanceListSorted(Interceptor.class, role);
        for (Interceptor interceptor : sortedInterceptorList) {
            if (!(interceptor instanceof AbstractLinkedInterceptor)) {
                log.warn("The Interceptor(" + interceptor.getClass().getCanonicalName() + ") is not an instance of AbstractLinkedInterceptor, can't be added into InterceptorChain");
                continue;
            }
            ((InterceptorChain)chain).addLast((AbstractLinkedInterceptor)interceptor);
        }
        return chain;
    }
}

