/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.interceptor.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import kd.bos.mservice.rpc.interceptor.spi.Intercept;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpiLoader {
    private static final Logger log = LoggerFactory.getLogger(SpiLoader.class);

    public static <T> List<T> loadPrototypeInstanceListSorted(Class<T> clazz, String role) {
        try {
            ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz);
            ArrayList orderWrappers = new ArrayList();
            for (T spi : serviceLoader) {
                int order = SpiResolver.resolveOrder(spi);
                String group = SpiResolver.resolveGroup(spi);
                SpiResolver.insertSorted(orderWrappers, spi, order, group);
                log.info("[SpiLoader interceptor] Found {} SPI: {} with order {} and group {}", new Object[]{clazz.getSimpleName(), spi.getClass().getCanonicalName(), order, group});
            }
            ArrayList<Object> list = new ArrayList<Object>(orderWrappers.size());
            for (int i = 0; i < orderWrappers.size(); ++i) {
                if (!SpiLoader.isThisRole(role, ((SpiOrderWrapper)orderWrappers.get(i)).group)) continue;
                list.add(((SpiOrderWrapper)orderWrappers.get(i)).spi);
            }
            return list;
        }
        catch (Exception t) {
            log.error("[SpiLoader interceptor] ERROR: loadPrototypeInstanceListSorted failed", (Throwable)t);
            return new ArrayList();
        }
    }

    private static boolean isThisRole(String role, String group) {
        return role.equals(group);
    }

    private static class SpiOrderWrapper<T> {
        private final int order;
        private final String group;
        private final T spi;

        SpiOrderWrapper(int order, String group, T spi) {
            this.order = order;
            this.group = group;
            this.spi = spi;
        }

        int getOrder() {
            return this.order;
        }

        String getGroup() {
            return this.group;
        }

        T getSpi() {
            return this.spi;
        }
    }

    private static class SpiResolver {
        private SpiResolver() {
        }

        private static <T> void insertSorted(List<SpiOrderWrapper<T>> list, T spi, int order, String group) {
            int idx;
            for (idx = 0; idx < list.size() && list.get(idx).getOrder() <= order; ++idx) {
            }
            list.add(idx, new SpiOrderWrapper<T>(order, group, spi));
        }

        private static <T> int resolveOrder(T spi) {
            if (!spi.getClass().isAnnotationPresent(Intercept.class)) {
                return Integer.MAX_VALUE;
            }
            return spi.getClass().getAnnotation(Intercept.class).order();
        }

        private static <T> String resolveGroup(T spi) {
            if (!spi.getClass().isAnnotationPresent(Intercept.class)) {
                return null;
            }
            return spi.getClass().getAnnotation(Intercept.class).group();
        }
    }
}

