/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.rest.codec;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kd.bos.mservice.rpc.rest.manager.BosRestTemplateManager;
import kd.bos.mservice.rpc.serialization.HttpHeadUtils;
import kd.bos.mservice.sdk.thread.InnerThreadTruck;
import kd.bos.mservice.serialization.KServiceSerializationFactory;
import kd.bos.mservice.serialization.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

@Configuration
public class BosRestMessageConverter
extends AbstractHttpMessageConverter<Serializable> {
    private static final Logger logger = LoggerFactory.getLogger(BosRestMessageConverter.class);

    public BosRestMessageConverter() {
        super(new MediaType("application", "xx-rest-converter", StandardCharsets.UTF_8));
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected Serializable readInternal(Class<? extends Serializable> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        String codecType = HttpHeadUtils.getHeader(inputMessage.getHeaders(), "codecType");
        if (codecType == null) {
            throw new SerializationException("has no codec type from bosRestMessageConverter readInternal");
        }
        if (KServiceSerializationFactory.isBinarySerialization((String)codecType)) {
            return (Serializable)KServiceSerializationFactory.getSerializer((String)codecType).deserialize(inputMessage.getBody(), null);
        }
        InnerThreadTruck.put((Object)"delay_dedeserialize", (Object)inputMessage.getBody());
        return "delay_dedeserialize";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInternal(Serializable t, HttpOutputMessage outputMessage) throws HttpMessageNotWritableException {
        try {
            String codecType = BosRestTemplateManager.getCodeType();
            if (codecType == null) {
                codecType = "javaobj";
                this.setHeaderIfEmpty(outputMessage.getHeaders(), "codecType", codecType);
            }
            if (t instanceof String) {
                OutputStream outputStream = outputMessage.getBody();
                outputStream.write(((String)((Object)t)).getBytes());
                outputStream.flush();
                return;
            }
            KServiceSerializationFactory.getSerializer((String)codecType).serialize((Object)t, outputMessage.getBody());
        }
        catch (Throwable e) {
            logger.error("BosHttpMessageConverter write error", e);
        }
        finally {
            BosRestTemplateManager.removeCodeType();
        }
    }

    private void setHeaderIfEmpty(HttpHeaders headers, String key, String value) {
        List collections = headers.get((Object)key);
        if (collections == null || collections.isEmpty()) {
            headers.add(key, value);
        }
    }
}

