/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.rest.config;

import java.io.IOException;
import java.net.SocketTimeoutException;
import kd.bos.mservice.common.exception.RpcException;
import kd.bos.mservice.rpc.rest.manager.BosRestTemplateManager;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.AsyncLoadBalancerAutoConfiguration;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.cloud.loadbalancer.config.LoadBalancerAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@LoadBalancerClients
@AutoConfigureAfter(value={LoadBalancerAutoConfiguration.class})
@AutoConfigureBefore(value={org.springframework.cloud.client.loadbalancer.LoadBalancerAutoConfiguration.class, AsyncLoadBalancerAutoConfiguration.class})
@ConditionalOnMissingClass(value={"org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerClient"})
@ConditionalOnClass(value={RestTemplate.class})
@ConditionalOnProperty(value={"spring.cloud.loadbalancer.enabled"}, havingValue="true", matchIfMissing=true)
public class RestBlockingLoadBalancerClient
extends BlockingLoadBalancerClient {
    public RestBlockingLoadBalancerClient(ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerClientFactory) {
        super(loadBalancerClientFactory);
    }

    public <T> T execute(String serviceId, LoadBalancerRequest<T> request) throws IOException {
        try {
            Object object = super.execute(serviceId, request);
            return (T)object;
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException) {
                throw new RpcException.RpcServiceUnavailableException((Throwable)e);
            }
            if (e instanceof SocketTimeoutException) {
                throw new RpcException.RpcTimeoutException((String)BosRestTemplateManager.get("ipAndPort"), (Throwable)e);
            }
            throw e;
        }
        finally {
            BosRestTemplateManager.remove("ipAndPort");
        }
    }

    public <T> ServiceInstance choose(String serviceId, Request<T> request) {
        ServiceInstance serviceInstance = super.choose(serviceId, request);
        if (serviceInstance != null) {
            BosRestTemplateManager.put("ipAndPort", serviceInstance.getHost() + ":" + serviceInstance.getPort());
        }
        return serviceInstance;
    }

    public ServiceInstance choose(String serviceId) {
        ServiceInstance serviceInstance = super.choose(serviceId);
        if (serviceInstance != null) {
            BosRestTemplateManager.put("ipAndPort", serviceInstance.getHost() + ":" + serviceInstance.getPort());
        }
        return serviceInstance;
    }
}

