/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.rest.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import kd.bos.mservice.sdk.util.SdkJSONUtils;
import kd.bos.mservice.serialization.KServiceSerializationFactory;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.UnknownHttpStatusCodeException;

public class RestResponseErrorHandler
implements ResponseErrorHandler {
    public boolean hasError(ClientHttpResponse response) throws IOException {
        int rawStatusCode = response.getRawStatusCode();
        HttpStatus statusCode = HttpStatus.resolve((int)rawStatusCode);
        return statusCode != null ? this.hasError(statusCode) : this.hasError(rawStatusCode);
    }

    protected boolean hasError(HttpStatus statusCode) {
        return statusCode.isError();
    }

    protected boolean hasError(int unknownStatusCode) {
        HttpStatus.Series series = HttpStatus.Series.resolve((int)unknownStatusCode);
        return series == HttpStatus.Series.CLIENT_ERROR || series == HttpStatus.Series.SERVER_ERROR;
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode = HttpStatus.resolve((int)response.getRawStatusCode());
        HttpHeaders headers = response.getHeaders();
        if (statusCode == null) {
            byte[] body = null;
            String message = this.getErrorMessage(headers, response.getRawStatusCode(), response.getStatusText(), response.getBody(), this.getCharset(response));
            throw new UnknownHttpStatusCodeException(message, response.getRawStatusCode(), response.getStatusText(), response.getHeaders(), body, this.getCharset(response));
        }
        this.handleError(response, statusCode);
    }

    protected void handleError(ClientHttpResponse response, HttpStatus statusCode) throws IOException {
        String statusText = response.getStatusText();
        HttpHeaders headers = response.getHeaders();
        InputStream in = response.getBody();
        byte[] body = null;
        Charset charset = this.getCharset(response);
        String message = this.getErrorMessage(headers, statusCode.value(), statusText, in, charset);
        switch (statusCode.series()) {
            case CLIENT_ERROR: {
                throw HttpClientErrorException.create((String)message, (HttpStatus)statusCode, (String)statusText, (HttpHeaders)headers, body, (Charset)charset);
            }
            case SERVER_ERROR: {
                throw HttpServerErrorException.create((String)message, (HttpStatus)statusCode, (String)statusText, (HttpHeaders)headers, body, (Charset)charset);
            }
        }
        throw new UnknownHttpStatusCodeException(message, statusCode.value(), statusText, headers, body, charset);
    }

    private String getErrorMessage(HttpHeaders headers, int rawStatusCode, String statusText, @Nullable InputStream inputStream, @Nullable Charset charset) throws IOException {
        String preface = rawStatusCode + " " + statusText + ": ";
        if (ObjectUtils.isEmpty((Object)inputStream)) {
            return preface + "[no body]";
        }
        List collection = headers.get((Object)"Content-Type");
        if (collection != null) {
            for (String contentType : collection) {
                String bodyText;
                if (!contentType.contains("application/xx-rest-converter") && !contentType.contains("application/xx-kd-serialization")) continue;
                try {
                    Serializable s = (Serializable)KServiceSerializationFactory.getDefaultBinarySerializer().deserialize(inputStream, null);
                    bodyText = s instanceof Throwable ? this.toJsonString((Throwable)s) : SdkJSONUtils.toString((Object)s);
                }
                catch (Exception e) {
                    bodyText = "restResponseErrorHandler deserialize failed to serializing business exceptions; " + e.getMessage();
                }
                bodyText = LogFormatUtils.formatValue((Object)bodyText, (int)-1, (boolean)true);
                return preface + bodyText;
            }
        }
        charset = charset != null ? charset : StandardCharsets.UTF_8;
        String bodyText = new String(FileCopyUtils.copyToByteArray((InputStream)inputStream), charset);
        bodyText = LogFormatUtils.formatValue((Object)bodyText, (int)-1, (boolean)true);
        return preface + bodyText;
    }

    private String toJsonString(Throwable t) throws Exception {
        ObjectMapper om = new ObjectMapper();
        if (t == null) {
            throw new NullPointerException();
        }
        try {
            Throwable detail;
            Throwable e = this.extractException(t);
            if (e == null) {
                e = t;
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            for (detail = e; detail != null && detail.getCause() != null; detail = detail.getCause()) {
            }
            if (detail != null) {
                detail.printStackTrace(pw);
            } else {
                pw.println("         ====================up is the cause exception,below is more =====================     ");
                e.printStackTrace(pw);
            }
            pw.flush();
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("errorInfo", sw.toString());
            return om.writeValueAsString(param);
        }
        catch (Exception e2) {
            return om.writeValueAsString((Object)t);
        }
    }

    private Throwable extractException(Throwable e) {
        Throwable result = e;
        while (e != null) {
            if (e.getClass().equals(RuntimeException.class)) {
                return e;
            }
            if (e instanceof NullPointerException) {
                return e;
            }
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
                continue;
            }
            e = e.getCause();
        }
        return result;
    }

    @Nullable
    protected Charset getCharset(ClientHttpResponse response) {
        HttpHeaders headers = response.getHeaders();
        MediaType contentType = headers.getContentType();
        return contentType != null ? contentType.getCharset() : null;
    }
}

