/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.serialization;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import kd.bos.mservice.common.exception.RpcException;
import kd.bos.mservice.rpc.serialization.HttpHeadUtils;
import kd.bos.mservice.serialization.KServiceSerializationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.server.ServletServerHttpResponse;

public class KdSerializationConverter
extends AbstractHttpMessageConverter<Serializable> {
    private static final Logger log = LoggerFactory.getLogger(KdSerializationConverter.class);

    public KdSerializationConverter() {
        super(new MediaType("application", "xx-kd-serialization", StandardCharsets.UTF_8));
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected Serializable readInternal(Class<? extends Serializable> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        String codecType = HttpHeadUtils.getHeader(inputMessage.getHeaders(), "codecType");
        if (codecType == null) {
            return (Serializable)KServiceSerializationFactory.getDefaultBinarySerializer().deserialize(inputMessage.getBody(), clazz);
        }
        return (Serializable)KServiceSerializationFactory.getSerializer((String)codecType).deserialize(inputMessage.getBody(), clazz);
    }

    protected void writeInternal(Serializable t, HttpOutputMessage outputMessage) throws HttpMessageNotWritableException {
        try {
            HttpServletResponse httpServerHttpResponse;
            String codecType;
            if (outputMessage instanceof ServletServerHttpResponse && (codecType = (httpServerHttpResponse = ((ServletServerHttpResponse)outputMessage).getServletResponse()).getHeader("codecType")) != null) {
                String cname = t.getClass().getName();
                if (cname.equals(RpcException.RpcServerException.class.getName()) || cname.equals("kd.bos.mservice.result.KServiceResponseData") || cname.equals("kd.bos.exception.KDException")) {
                    httpServerHttpResponse.setHeader("codecType", null);
                } else {
                    KServiceSerializationFactory.getSerializer((String)codecType).serialize((Object)t, outputMessage.getBody());
                    return;
                }
            }
            KServiceSerializationFactory.getDefaultBinarySerializer().serialize((Object)t, outputMessage.getBody());
        }
        catch (Throwable e) {
            log.error("fegin service write error", e);
        }
    }
}

