/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filestorage.s3.auth.aws.v4;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.filestorage.s3.util.DataUtils;
import kd.bos.filestorage.s3.util.HttpUtils;
import kd.bos.util.PropertiesUtil;

public abstract class AWSV4SignerBase {
    public static final String EMPTY_BODY_SHA256 = PropertiesUtil.getConstant((String)"EMPTY_BODY_SHA256");
    public static final String SCHEME = "AWS4";
    public static final String ALGORITHM = "HMAC-SHA256";
    public static final String TERMINATOR = "aws4_request";
    public static final String ISO_8601_BASIC_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    public static final String DATE_STRING_FORMAT = "yyyyMMdd";
    protected URL endpointUrl;
    protected String httpMethod;
    protected String serviceName;
    protected String regionName = "";
    protected final SimpleDateFormat dateTimeFormat;
    protected final SimpleDateFormat dateStampFormat;

    public AWSV4SignerBase(String url, String httpMethod, String serviceName) {
        try {
            this.endpointUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to parse service endpoint: " + e.getMessage(), e);
        }
        this.httpMethod = httpMethod;
        this.serviceName = serviceName;
        this.dateTimeFormat = new SimpleDateFormat(ISO_8601_BASIC_FORMAT);
        this.dateTimeFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        this.dateStampFormat = new SimpleDateFormat(DATE_STRING_FORMAT);
        this.dateStampFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
    }

    protected static String getCanonicalizeHeaderNames(Map<String, String> headers) {
        ArrayList<String> sortedHeaders = new ArrayList<String>(headers.keySet());
        sortedHeaders.sort(String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            if (buffer.length() > 0) {
                buffer.append(';');
            }
            buffer.append(header.toLowerCase());
        }
        return buffer.toString();
    }

    protected static String getCanonicalizedHeaderString(Map<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            return "";
        }
        ArrayList<String> sortedHeaders = new ArrayList<String>(headers.keySet());
        sortedHeaders.sort(String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String key : sortedHeaders) {
            buffer.append(key.toLowerCase().replaceAll("\\s+", " ")).append(':').append(headers.get(key).replaceAll("\\s+", " "));
            buffer.append('\n');
        }
        return buffer.toString();
    }

    protected static String getCanonicalRequest(URL endpoint, String httpMethod, String queryParameters, String canonicalizedHeaderNames, String canonicalizedHeaders, String bodyHash) {
        return httpMethod + "\n" + AWSV4SignerBase.getCanonicalizedResourcePath(endpoint) + "\n" + queryParameters + "\n" + canonicalizedHeaders + "\n" + canonicalizedHeaderNames + "\n" + bodyHash;
    }

    protected static String getCanonicalizedResourcePath(URL endpoint) {
        if (endpoint == null) {
            return "/";
        }
        String path = endpoint.getPath();
        if (path == null || path.isEmpty()) {
            return "/";
        }
        String encodedPath = HttpUtils.urlEncode(path, true);
        if (encodedPath.startsWith("/")) {
            return encodedPath;
        }
        return "/".concat(encodedPath);
    }

    public static String getCanonicalizedQueryString(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        for (Map.Entry<String, String> pair : parameters.entrySet()) {
            String key = pair.getKey();
            String value = pair.getValue();
            sorted.put(HttpUtils.urlEncode(key, false), HttpUtils.urlEncode(value, false));
        }
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<String, String>> pairs = sorted.entrySet().iterator();
        while (pairs.hasNext()) {
            Map.Entry<String, String> pair = pairs.next();
            builder.append(pair.getKey());
            builder.append('=');
            builder.append(pair.getValue());
            if (!pairs.hasNext()) continue;
            builder.append('&');
        }
        return builder.toString();
    }

    protected static String getStringToSign(String dateTime, String scope, String canonicalRequest) {
        return "AWS4-HMAC-SHA256\n" + dateTime + "\n" + scope + "\n" + DataUtils.toHex(AWSV4SignerBase.hash(canonicalRequest));
    }

    public static byte[] hash(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text.getBytes(StandardCharsets.UTF_8));
            return md.digest();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    public static byte[] hash(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(data);
            return md.digest();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    protected static byte[] sign(String stringData, byte[] key) {
        try {
            byte[] data = stringData.getBytes(StandardCharsets.UTF_8);
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }
}

