/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filestorage.s3.auth.aws.v4;

import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import kd.bos.filestorage.s3.auth.aws.v4.AWSV4SignerBase;
import kd.bos.filestorage.s3.util.DataUtils;

public class AWSV4SignerForAuthorizationHeader
extends AWSV4SignerBase {
    public AWSV4SignerForAuthorizationHeader(String url, String httpMethod, String serviceName) {
        super(url, httpMethod, serviceName);
    }

    public String computeSignature(Map<String, String> headers, Map<String, String> queryParameters, String bodyHash, String awsAccessKey, String awsSecretKey) {
        Date now = new Date();
        String dateTimeStamp = this.dateTimeFormat.format(now);
        headers.put("x-amz-date", dateTimeStamp);
        String hostHeader = this.endpointUrl.getHost();
        int port = this.endpointUrl.getPort();
        if (port > -1) {
            hostHeader = hostHeader.concat(":" + port);
        }
        headers.put("Host", hostHeader);
        String canonicalizedHeaderNames = AWSV4SignerForAuthorizationHeader.getCanonicalizeHeaderNames(headers);
        String canonicalizedHeaders = AWSV4SignerForAuthorizationHeader.getCanonicalizedHeaderString(headers);
        String canonicalizedQueryParameters = AWSV4SignerForAuthorizationHeader.getCanonicalizedQueryString(queryParameters);
        String canonicalRequest = AWSV4SignerForAuthorizationHeader.getCanonicalRequest(this.endpointUrl, this.httpMethod, canonicalizedQueryParameters, canonicalizedHeaderNames, canonicalizedHeaders, bodyHash);
        String dateStamp = this.dateStampFormat.format(now);
        String scope = dateStamp + "/" + this.regionName + "/" + this.serviceName + "/" + "aws4_request";
        String stringToSign = AWSV4SignerForAuthorizationHeader.getStringToSign(dateTimeStamp, scope, canonicalRequest);
        byte[] kSecret = ("AWS4" + awsSecretKey).getBytes(StandardCharsets.UTF_8);
        byte[] kDate = AWSV4SignerForAuthorizationHeader.sign(dateStamp, kSecret);
        byte[] kRegion = AWSV4SignerForAuthorizationHeader.sign(this.regionName, kDate);
        byte[] kService = AWSV4SignerForAuthorizationHeader.sign(this.serviceName, kRegion);
        byte[] kSigning = AWSV4SignerForAuthorizationHeader.sign("aws4_request", kService);
        byte[] signature = AWSV4SignerForAuthorizationHeader.sign(stringToSign, kSigning);
        String credentialsAuthorizationHeader = "Credential=" + awsAccessKey + "/" + scope;
        String signedHeadersAuthorizationHeader = "SignedHeaders=" + canonicalizedHeaderNames;
        String signatureAuthorizationHeader = "Signature=" + DataUtils.toHex(signature);
        return "AWS4-HMAC-SHA256 " + credentialsAuthorizationHeader + ", " + signedHeadersAuthorizationHeader + ", " + signatureAuthorizationHeader;
    }
}

