/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bdsync.check;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowUtil;
import kd.bos.bdsync.BDSyncCheckMsg;
import kd.bos.bdsync.ErrorRowInfo;
import kd.bos.bdsync.check.EqualsUtil;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.DataCacheReader;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.ksql.KSQLThreadCache;
import kd.bos.orm.datasync.agent.MetaTable;
import kd.bos.orm.datasync.agent.RelationTablesCache;
import kd.bos.util.StringUtils;

public class BDSyncChecker {
    public static BDSyncCheckMsg check(String entityNumber, DBRoute destinationRoute) {
        DynamicObjectType entityType = DataCacheReader.get().getDataEntityType(entityNumber);
        DBRoute sourceRoute = DBRoute.of((String)entityType.getDBRouteKey());
        String pkName = entityType.getPrimaryKey().getAlias();
        String tableName = entityType.getAlias().toLowerCase();
        Set<Object> pkSet = BDSyncChecker.getPKSet(sourceRoute, tableName, pkName);
        BDSyncCheckMsg bcm = BDSyncChecker.checkByPKSet(entityNumber, pkSet, destinationRoute);
        return bcm;
    }

    public static BDSyncCheckMsg checkByPKSet(String entityNumber, Set<Object> pkSet, DBRoute destinationRoute) {
        DynamicObjectType entityType = DataCacheReader.get().getDataEntityType(entityNumber);
        DBRoute sourceRoute = DBRoute.of((String)entityType.getDBRouteKey());
        String tableName = entityType.getAlias().toLowerCase();
        Map metaTableMap = RelationTablesCache.get().getMetaTableMap(entityNumber);
        MetaTable metaTable = (MetaTable)metaTableMap.get(tableName.toLowerCase());
        ArrayList<ErrorRowInfo> errorInfos = new ArrayList<ErrorRowInfo>(5);
        BDSyncChecker.doCompare(sourceRoute, destinationRoute, errorInfos, metaTable, Arrays.asList(pkSet.toArray(new Object[0])));
        BDSyncCheckMsg bdSyncCheckMsg = new BDSyncCheckMsg();
        bdSyncCheckMsg.setEntityNumber(entityNumber);
        if (errorInfos.isEmpty()) {
            bdSyncCheckMsg.setConsistent(true);
        } else {
            bdSyncCheckMsg.setConsistent(false);
        }
        bdSyncCheckMsg.addErrorInfos(errorInfos);
        return bdSyncCheckMsg;
    }

    private static void doCompare(DBRoute sourceRoute, DBRoute targetRoute, List<ErrorRowInfo> errorRowInfos, MetaTable metaTable, List<Object> pkList) {
        if (!pkList.isEmpty()) {
            List<List<Object>> splitList = BDSyncChecker.splitArrayList(pkList);
            String curentPrimartKey = metaTable.getPrimaryKey();
            String currentTableName = metaTable.getTableName();
            for (List<Object> range : splitList) {
                if (!metaTable.getChildrenTableMap().isEmpty()) {
                    for (MetaTable childrenMetaTable : new ArrayList(metaTable.getChildrenTableMap().values())) {
                        BDSyncChecker.queryAndCompareTable(sourceRoute, targetRoute, errorRowInfos, childrenMetaTable, range);
                    }
                }
                errorRowInfos.addAll(BDSyncChecker.compareTable(sourceRoute, targetRoute, currentTableName, curentPrimartKey, curentPrimartKey, range.toArray(new Object[0])));
            }
        }
    }

    private static void queryAndCompareTable(DBRoute sourceRoute, DBRoute targetRoute, List<ErrorRowInfo> errorRowInfos, MetaTable metaTable, List<Object> pkList) {
        if (metaTable.getChildrenTableMap().isEmpty()) {
            String relationField = metaTable.getRelationField();
            String pk = metaTable.getPrimaryKey();
            String tableName = metaTable.getTableName();
            errorRowInfos.addAll(BDSyncChecker.compareTable(sourceRoute, targetRoute, tableName, pk, relationField, pkList.toArray(new Object[0])));
        } else {
            String currentTable = metaTable.getTableName();
            String currentPrimaryKey = metaTable.getPrimaryKey();
            SqlBuilder sql = new SqlBuilder();
            String relationField = StringUtils.isEmpty((String)metaTable.getRelationField()) ? metaTable.getPrimaryKey() : metaTable.getRelationField();
            sql.append("select ", new Object[0]).append(currentPrimaryKey, new Object[0]).append(" from ", new Object[0]).append(currentTable, new Object[0]).append(" where ", new Object[0]).appendIn(relationField, pkList);
            ArrayList<Object> currentPks = new ArrayList<Object>();
            try (DataSet ds = DB.queryDataSet((String)("DeleteSqlInfoCreater" + currentTable), (DBRoute)sourceRoute, (SqlBuilder)sql);){
                while (ds.hasNext()) {
                    Row r = ds.next();
                    Object currentPkValue = r.get(currentPrimaryKey);
                    currentPks.add(currentPkValue);
                }
            }
            BDSyncChecker.doCompare(sourceRoute, targetRoute, errorRowInfos, metaTable, currentPks);
        }
    }

    private static List<List<Object>> splitArrayList(List<Object> pks) {
        ArrayList<List<Object>> ranges = new ArrayList<List<Object>>(10);
        int pageSize = 1000;
        if (pks.size() <= pageSize) {
            ranges.add(pks);
        } else {
            int toIndex;
            int total = pks.size();
            int i = 0;
            do {
                int fromIndex = i;
                toIndex = Math.min(i += pageSize, total) - 1;
                List<Object> range = pks.subList(fromIndex, toIndex + 1);
                ranges.add(range);
            } while (toIndex != total - 1);
        }
        return ranges;
    }

    private static List<ErrorRowInfo> compareTable(DBRoute sourceRoute, DBRoute targetRoute, String tableName, String pkField, String relationField, Object[] relationFieldVaues) {
        KSQLThreadCache.put((Object)"check.selectAllColumn", (Object)Boolean.FALSE);
        ArrayList<ErrorRowInfo> errorInfos = new ArrayList<ErrorRowInfo>(2);
        SqlBuilder sourceSqlBuilder = new SqlBuilder();
        sourceSqlBuilder.append("select * from ", new Object[0]);
        sourceSqlBuilder.append(tableName, new Object[0]).append(" where ", new Object[0]).appendIn(relationField, relationFieldVaues);
        sourceSqlBuilder.append(" order by ", new Object[0]);
        if (!relationField.equalsIgnoreCase(pkField)) {
            sourceSqlBuilder.append(relationField, new Object[0]).append(" asc, ", new Object[0]);
        }
        sourceSqlBuilder.append(pkField, new Object[0]).append(" asc ", new Object[0]);
        SqlBuilder targetSqlBuilder = new SqlBuilder();
        targetSqlBuilder.append("select * from ", new Object[0]);
        targetSqlBuilder.append(tableName, new Object[0]).append(" where ", new Object[0]).appendIn(relationField, relationFieldVaues);
        targetSqlBuilder.append(" order by ", new Object[0]);
        if (!relationField.equalsIgnoreCase(pkField)) {
            targetSqlBuilder.append(relationField, new Object[0]).append(" asc, ", new Object[0]);
        }
        targetSqlBuilder.append(pkField, new Object[0]).append(" asc ", new Object[0]);
        try (DataSet sourceDs = DB.queryDataSet((String)"BDSyncChecker", (DBRoute)sourceRoute, (SqlBuilder)sourceSqlBuilder);
             DataSet targetDs = DB.queryDataSet((String)"BDSyncChecker", (DBRoute)targetRoute, (SqlBuilder)targetSqlBuilder);){
            Object pkValue;
            String[] fieldNames = sourceDs.getRowMeta().getFieldNames();
            HashMap<String, Row> sourceRowMap = new HashMap<String, Row>(10);
            HashMap<String, Row> targetRowMap = new HashMap<String, Row>(10);
            while (sourceDs.hasNext()) {
                Row sourceRow = RowUtil.persist((Row)sourceDs.next());
                pkValue = sourceRow.get(pkField);
                sourceRowMap.put(pkValue.toString(), sourceRow);
            }
            while (targetDs.hasNext()) {
                Row targetRow = RowUtil.persist((Row)targetDs.next());
                pkValue = targetRow.get(pkField);
                targetRowMap.put(pkValue.toString(), targetRow);
            }
            for (Map.Entry iter : sourceRowMap.entrySet()) {
                String sourcePk = (String)iter.getKey();
                Row sourceRow = (Row)iter.getValue();
                Row targetRow = (Row)targetRowMap.get(sourcePk);
                if (targetRow == null) {
                    ErrorRowInfo errorInfo = new ErrorRowInfo();
                    errorInfo.setTableName(tableName);
                    errorInfo.setRelationFieldName(relationField);
                    errorInfo.setRelationFieldValue(sourceRow.get(relationField));
                    String[] stringArray = fieldNames;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String field = stringArray[i];
                        errorInfo.putSourceField(field, sourceRow.get(field));
                    }
                    errorInfos.add(errorInfo);
                    continue;
                }
                for (String fieldName : fieldNames) {
                    if (EqualsUtil.equals(sourceRow.get(fieldName), targetRow.get(fieldName))) continue;
                    ErrorRowInfo errorInfo = new ErrorRowInfo();
                    errorInfo.setTableName(tableName);
                    errorInfo.setRelationFieldName(relationField);
                    errorInfo.setRelationFieldValue(sourceRow.get(relationField));
                    errorInfo.putSourceField(fieldName, sourceRow.get(fieldName));
                    errorInfo.putTargetField(fieldName, targetRow.get(fieldName));
                    errorInfos.add(errorInfo);
                    break;
                }
                targetRowMap.remove(sourcePk);
            }
            for (Map.Entry iter : targetRowMap.entrySet()) {
                Row targetRow = (Row)iter.getValue();
                ErrorRowInfo errorInfo = new ErrorRowInfo();
                errorInfo.setTableName(tableName);
                errorInfo.setRelationFieldName(relationField);
                errorInfo.setRelationFieldValue(targetRow.get(relationField));
                for (String field : fieldNames) {
                    errorInfo.putTargetField(field, targetRow.get(field));
                }
                errorInfos.add(errorInfo);
            }
        }
        return errorInfos;
    }

    private static Set<Object> getPKSet(DBRoute route, String tableName, String pkName) {
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append(pkName).append(" from ").append(tableName);
        return (Set)DB.query((DBRoute)route, (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<Set<Object>>(){

            public Set<Object> handle(ResultSet rs) throws Exception {
                HashSet<Object> pkSet = new HashSet<Object>(10);
                while (rs.next()) {
                    pkSet.add(rs.getObject(1));
                }
                return pkSet;
            }
        });
    }

    @Deprecated
    private static List<ErrorRowInfo> comparePK(String tableName, String pkName, DBRoute sourceRoute, DBRoute targetRoute) {
        ErrorRowInfo info;
        ArrayList<ErrorRowInfo> erroInfos = new ArrayList<ErrorRowInfo>(5);
        Set<Object> sourcePKSet = BDSyncChecker.getPKSet(sourceRoute, tableName, pkName);
        Set<Object> targetPKSet = BDSyncChecker.getPKSet(targetRoute, tableName, pkName);
        HashSet<Object> inSourceButTargetSet = new HashSet<Object>(5);
        HashSet<Object> inTargetButSourceSet = new HashSet<Object>(5);
        for (Object pk : sourcePKSet) {
            if (targetPKSet.contains(pk)) continue;
            inSourceButTargetSet.add(pk);
        }
        for (Object pk : targetPKSet) {
            if (sourcePKSet.contains(pk)) continue;
            inTargetButSourceSet.add(pk);
        }
        if (!inSourceButTargetSet.isEmpty()) {
            for (Object pk : inSourceButTargetSet) {
                info = new ErrorRowInfo();
                info.setRelationFieldName(pkName);
                info.setTableName(tableName);
                info.setRelationFieldValue(pk);
                info.putSourceField(pkName, pk);
                erroInfos.add(info);
            }
        }
        if (!inTargetButSourceSet.isEmpty()) {
            for (Object pk : inTargetButSourceSet) {
                info = new ErrorRowInfo();
                info.setRelationFieldName(pkName);
                info.setTableName(tableName);
                info.setRelationFieldValue(pk);
                info.putTargetField(pkName, pk);
                erroInfos.add(info);
            }
        }
        return erroInfos;
    }
}

