/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bdsync.init.table;

import java.util.List;
import java.util.Set;
import kd.bos.archive.tablemanager.meta.Imeta;
import kd.bos.archive.tablemanager.meta.MetaFactory;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.util.StringUtils;
import kd.bos.xdb.tablemanager.meta.CreateIndexSqlInfo;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public class AbstractTableCreater {
    public void createTable(Set<String> tables, DBRoute sourceRoute, DBRoute destinationRoute) {
        Imeta meta = MetaFactory.getMeta((DBRoute)sourceRoute);
        for (String table : tables) {
            String likeTable = DB.getOriginalsnapTableNameIfShardingTable((String)table);
            List columnlist = meta.queryColumns(sourceRoute, likeTable);
            String sql = meta.createTableSql(table, columnlist);
            this.executeSql(destinationRoute, this.getDialectSql(sql));
        }
    }

    public void createIndex(Set<String> tables, DBRoute sourceRoute, DBRoute destinationRoute) {
        Imeta meta = MetaFactory.getMeta((DBRoute)sourceRoute);
        for (String table : tables) {
            String likeTable;
            PkInfo pkInfo;
            String createPKSql = meta.createPkIndexSql(table, pkInfo = meta.queryPkInfo(sourceRoute, likeTable = DB.getOriginalsnapTableNameIfShardingTable((String)table)), null);
            if (StringUtils.isNotEmpty((String)createPKSql)) {
                this.executeSql(destinationRoute, this.getDialectSql(createPKSql));
            }
            List createIndexInfos = meta.createIndexSql(sourceRoute, table, table, pkInfo, null);
            for (CreateIndexSqlInfo createIndexInfo : createIndexInfos) {
                String indexSql = createIndexInfo.getCreateIndexSql();
                this.executeSql(destinationRoute, this.getDialectSql(indexSql));
            }
        }
    }

    public void dropTable(Set<String> tables, DBRoute sourceRoute, DBRoute destinationRoute) {
        tables.forEach(tableName -> {
            tableName = tableName.toUpperCase();
            StringBuilder dropSql = new StringBuilder();
            dropSql.append("IF EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '").append((String)tableName).append("')\n");
            dropSql.append("DROP TABLE \"").append((String)tableName).append('\"');
            this.executeSql(destinationRoute, dropSql.toString());
        });
    }

    protected void executeSql(DBRoute destinationRoute, String sql) {
        try (DtsExcludeSyncContext context = DtsExcludeSyncContext.create();
             TXHandle h = TX.requiresNew((String)"BusinessDbTableCreater");){
            DB.execute((DBRoute)destinationRoute, (String)sql);
        }
    }

    protected String getDialectSql(String sql) {
        return "/*dialect*/" + sql;
    }
}

